/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.rest.internal.representations;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.Representation;
import org.xwiki.annotation.rest.model.jaxb.AnnotationField;
import org.xwiki.annotation.rest.model.jaxb.AnnotationRequest;
import org.xwiki.annotation.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.XWikiRestComponent;

public abstract class AbstractFormUrlEncodedAnnotationRequestReader<T extends AnnotationRequest>
implements MessageBodyReader<T>,
XWikiRestComponent {
    protected static final String REQUESTED_FIELD = "request_field";
    protected static final String FILTER_FIELD_PREFIX = "filter_";

    protected abstract T getReadObjectInstance(ObjectFactory var1);

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ObjectFactory objectFactory = new ObjectFactory();
        T annotationRequest = this.getReadObjectInstance(objectFactory);
        InputRepresentation representation = new InputRepresentation(entityStream, org.restlet.data.MediaType.APPLICATION_WWW_FORM);
        Form form = new Form((Representation)representation);
        if (form.getNames().size() != 0) {
            for (String paramName : form.getNames()) {
                for (String paramValue : form.getValuesArray(paramName)) {
                    this.saveField(annotationRequest, paramName, paramValue, objectFactory);
                }
            }
        } else {
            HttpServletRequest httpServletRequest = (HttpServletRequest)Context.getCurrent().getAttributes().get("httpRequest");
            for (Map.Entry entryObj : httpServletRequest.getParameterMap().entrySet()) {
                String[] paramValues;
                Map.Entry entry = entryObj;
                if ("method".equals(entry.getKey()) || "media".equals(entry.getKey())) continue;
                for (String value : paramValues = (String[])entry.getValue()) {
                    this.saveField(annotationRequest, (String)entry.getKey(), value, objectFactory);
                }
            }
        }
        return annotationRequest;
    }

    protected boolean saveField(T readObject, String key, String value, ObjectFactory objectFactory) {
        if (REQUESTED_FIELD.equals(key)) {
            ((AnnotationRequest)readObject).getRequest().getFields().add(value);
            return true;
        }
        if (key.startsWith(FILTER_FIELD_PREFIX)) {
            AnnotationField filterField = objectFactory.createAnnotationField();
            filterField.setName(key.substring(FILTER_FIELD_PREFIX.length()));
            filterField.setValue(value);
            ((AnnotationRequest)readObject).getFilter().getFields().add(filterField);
            return true;
        }
        return false;
    }
}

