/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.rest.internal;

import com.xpn.xwiki.XWikiException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.restlet.Request;
import org.restlet.data.Form;
import org.xwiki.annotation.AnnotationServiceException;
import org.xwiki.annotation.rest.internal.AbstractAnnotationRESTResource;
import org.xwiki.annotation.rest.model.jaxb.AnnotationAddRequest;
import org.xwiki.annotation.rest.model.jaxb.AnnotationField;
import org.xwiki.annotation.rest.model.jaxb.AnnotationFieldCollection;
import org.xwiki.annotation.rest.model.jaxb.AnnotationRequest;
import org.xwiki.annotation.rest.model.jaxb.AnnotationResponse;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rest.XWikiRestException;

@Component
@Named(value="org.xwiki.annotation.rest.internal.AnnotationsRESTResource")
@Path(value="/wikis/{wikiName}/spaces/{spaceName: .+}/pages/{pageName}/annotations")
@Singleton
public class AnnotationsRESTResource
extends AbstractAnnotationRESTResource {
    private static final String ANNOTATION_REQUEST_REQUESTED_FIELD_PARAMETER = "request_field";
    private static final String ANNOTATION_REQUEST_FILTER_PARAMETER_PREFIX = "filter_";
    @Inject
    private EntityReferenceSerializer<String> referenceSerializer;

    @GET
    public Response doGetAnnotatedContent(@PathParam(value="spaceName") String space, @PathParam(value="pageName") String page, @PathParam(value="wikiName") String wiki) throws XWikiRestException {
        try {
            DocumentReference documentReference = new DocumentReference(wiki, this.parseSpaceSegments(space), page);
            this.updateContext(documentReference);
            String documentName = (String)this.referenceSerializer.serialize((EntityReference)documentReference, new Object[0]);
            if (!this.annotationRightService.canViewAnnotatedTarget(documentName, this.getXWikiUser())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Form form = Request.getCurrent().getResourceRef().getQueryAsForm();
            AnnotationRequest request = new AnnotationRequest();
            AnnotationFieldCollection fields = new AnnotationFieldCollection();
            ArrayList<AnnotationField> annotationFields = new ArrayList<AnnotationField>();
            AnnotationRequest.Request requestedFields = new AnnotationRequest.Request();
            for (String name : form.getNames()) {
                if (StringUtils.startsWith((String)name, (String)ANNOTATION_REQUEST_FILTER_PARAMETER_PREFIX)) {
                    for (String value : form.getValuesArray(name)) {
                        AnnotationField field = new AnnotationField();
                        field.setName(StringUtils.substringAfter((String)name, (String)ANNOTATION_REQUEST_FILTER_PARAMETER_PREFIX));
                        field.setValue(value);
                        annotationFields.add(field);
                    }
                    continue;
                }
                if (!StringUtils.equals((String)name, (String)ANNOTATION_REQUEST_REQUESTED_FIELD_PARAMETER)) continue;
                requestedFields.getFields().addAll(Arrays.asList(form.getValuesArray(name)));
            }
            request.setRequest(requestedFields);
            fields.getFields().addAll(annotationFields);
            request.setFilter(fields);
            AnnotationResponse response = this.getSuccessResponseWithAnnotatedContent(documentName, request);
            return Response.ok((Object)response).expires(new Date()).build();
        }
        catch (AnnotationServiceException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return Response.ok((Object)this.getErrorResponse(e)).build();
        }
        catch (XWikiException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return Response.ok((Object)this.getErrorResponse(e)).build();
        }
    }

    @POST
    public AnnotationResponse doPostAnnotation(@PathParam(value="wikiName") String wiki, @PathParam(value="spaceName") String space, @PathParam(value="pageName") String page, AnnotationAddRequest request) throws XWikiRestException {
        try {
            DocumentReference documentReference = new DocumentReference(wiki, this.parseSpaceSegments(space), page);
            this.updateContext(documentReference);
            String documentName = (String)this.referenceSerializer.serialize((EntityReference)documentReference, new Object[0]);
            if (!this.annotationRightService.canAddAnnotation(documentName, this.getXWikiUser())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Map<String, Object> annotationMetadata = this.getMap(request.getAnnotation());
            this.annotationService.addAnnotation(documentName, request.getSelection(), request.getSelectionContext(), request.getSelectionOffset(), this.getXWikiUser(), annotationMetadata);
            AnnotationResponse response = this.getSuccessResponseWithAnnotatedContent(documentName, request);
            return response;
        }
        catch (AnnotationServiceException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return this.getErrorResponse(e);
        }
        catch (XWikiException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return this.getErrorResponse(e);
        }
    }

    protected Map<String, Object> getMap(AnnotationFieldCollection fields) {
        HashMap<String, Object> metadataMap = new HashMap<String, Object>();
        for (AnnotationField f : fields.getFields()) {
            metadataMap.put(f.getName(), f.getValue());
        }
        return metadataMap;
    }
}

