/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.rest.internal;

import com.xpn.xwiki.XWikiException;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.annotation.Annotation;
import org.xwiki.annotation.AnnotationServiceException;
import org.xwiki.annotation.rest.internal.AbstractAnnotationRESTResource;
import org.xwiki.annotation.rest.model.jaxb.AnnotationField;
import org.xwiki.annotation.rest.model.jaxb.AnnotationRequest;
import org.xwiki.annotation.rest.model.jaxb.AnnotationResponse;
import org.xwiki.annotation.rest.model.jaxb.AnnotationUpdateRequest;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rest.XWikiRestException;

@Component
@Named(value="org.xwiki.annotation.rest.internal.SingleAnnotationRESTResource")
@Path(value="/wikis/{wikiName}/spaces/{spaceName: .+}/pages/{pageName}/annotation/{id}")
@Singleton
public class SingleAnnotationRESTResource
extends AbstractAnnotationRESTResource {
    @Inject
    private EntityReferenceSerializer<String> referenceSerializer;

    @DELETE
    public AnnotationResponse doDelete(@PathParam(value="spaceName") String space, @PathParam(value="pageName") String page, @PathParam(value="wikiName") String wiki, @PathParam(value="id") String id, AnnotationRequest request) throws XWikiRestException {
        try {
            DocumentReference documentReference = new DocumentReference(wiki, this.parseSpaceSegments(space), page);
            this.updateContext(documentReference);
            String documentName = (String)this.referenceSerializer.serialize((EntityReference)documentReference, new Object[0]);
            if (!this.annotationRightService.canEditAnnotation(id, documentName, this.getXWikiUser())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            this.annotationService.removeAnnotation(documentName, id);
            AnnotationResponse response = this.getSuccessResponseWithAnnotatedContent(documentName, request);
            return response;
        }
        catch (XWikiException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return this.getErrorResponse(e);
        }
        catch (AnnotationServiceException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return this.getErrorResponse(e);
        }
    }

    @PUT
    public AnnotationResponse doUpdate(@PathParam(value="spaceName") String space, @PathParam(value="pageName") String page, @PathParam(value="wikiName") String wiki, @PathParam(value="id") String id, AnnotationUpdateRequest updateRequest) throws XWikiRestException {
        try {
            DocumentReference documentReference = new DocumentReference(wiki, this.parseSpaceSegments(space), page);
            this.updateContext(documentReference);
            String documentName = (String)this.referenceSerializer.serialize((EntityReference)documentReference, new Object[0]);
            if (!this.annotationRightService.canEditAnnotation(id, documentName, this.getXWikiUser())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Annotation newAnnotation = new Annotation(id);
            for (AnnotationField field : updateRequest.getAnnotation().getFields()) {
                newAnnotation.set(field.getName(), (Object)field.getValue());
            }
            newAnnotation.setAuthor(this.getXWikiUser());
            this.annotationService.updateAnnotation(documentName, newAnnotation);
            AnnotationResponse response = this.getSuccessResponseWithAnnotatedContent(documentName, updateRequest);
            return response;
        }
        catch (XWikiException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return this.getErrorResponse(e);
        }
        catch (AnnotationServiceException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            return this.getErrorResponse(e);
        }
    }
}

