/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.test.po;

import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.xwiki.annotation.test.po.AnnotationsLabel;
import org.xwiki.annotation.test.po.AnnotationsPane;
import org.xwiki.annotation.test.po.AnnotationsWindow;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.ViewPage;

public class AnnotatableViewPage
extends BaseElement {
    private static final String XWIKI_ANNOTATION_ADD_SUCCESS = "Annotation has been successfully added";
    private static final String XWIKI_ANNOTATION_DELETE_SUCCESS = "Annotation deleted";
    private static final String XWIKI_SYNTAX_1_WARNING = "Annotations are not available for documents in XWiki/1.0 syntax.";
    private AnnotationsPane annotationsPane;
    private AnnotationsWindow annotationsWindow;
    private AnnotationsLabel annotationsLabel;
    private StringBuilder script;
    private ViewPage viewPage;

    public AnnotatableViewPage(ViewPage viewPage) {
        this.viewPage = viewPage;
        this.script = new StringBuilder();
        this.script.append("function findString (str) {\n");
        this.script.append("  var strFound;\n");
        this.script.append("  if (window.find) {\n");
        this.script.append("    if (parseInt(navigator.appVersion)<4) return;\n");
        this.script.append("    // CODE FOR BROWSERS THAT SUPPORT window.find\n");
        this.script.append("    strFound = self.find(str);\n");
        this.script.append("    if (strFound && self.getSelection && !self.getSelection().anchorNode) {\n");
        this.script.append("      strFound = self.find(str);\n");
        this.script.append("    }\n");
        this.script.append("    if (!strFound) {\n");
        this.script.append("      strFound = self.find(str,0,1);\n");
        this.script.append("      while (self.find(str,0,1)) continue;\n");
        this.script.append("    }\n");
        this.script.append("  } else if (navigator.appName.indexOf(\"Microsoft\")!=-1) {\n");
        this.script.append("    // EXPLORER-SPECIFIC CODE\n");
        this.script.append("    if (TRange != null) {\n");
        this.script.append("      TRange.collapse(false);\n");
        this.script.append("      strFound = TRange.findText(str);\n");
        this.script.append("      if (strFound) TRange.select();\n");
        this.script.append("    }\n");
        this.script.append("    if (TRange == null || strFound == 0) {\n");
        this.script.append("      TRange = self.document.body.createTextRange();\n");
        this.script.append("      strFound = TRange.findText(str);\n");
        this.script.append("      if (strFound) TRange.select();\n");
        this.script.append("    }\n");
        this.script.append("  } else if (navigator.appName == \"Opera\") {\n");
        this.script.append("    alert ('Opera browsers not supported, sorry...');\n");
        this.script.append("    return;\n");
        this.script.append("  }\n");
        this.script.append("  if (!strFound) \n");
        this.script.append("    return;\n");
        this.script.append("}\n");
        ((JavascriptExecutor)this.getDriver()).executeScript(this.script.toString(), new Object[0]);
        this.annotationsPane = new AnnotationsPane();
        this.annotationsWindow = new AnnotationsWindow();
        this.annotationsLabel = new AnnotationsLabel();
    }

    public ViewPage getWrappedViewPage() {
        return this.viewPage;
    }

    public void addAnnotation(String annotatedText, String annotationText) {
        this.selectText(annotatedText);
        this.simulateCTRL_M();
        this.annotationsWindow.addAnnotation(annotationText);
        this.waitForNotificationSuccessMessage(XWIKI_ANNOTATION_ADD_SUCCESS);
    }

    public void deleteAnnotationByID(String id) {
        this.annotationsLabel.deleteAnnotationById(id);
        this.waitForNotificationSuccessMessage(XWIKI_ANNOTATION_DELETE_SUCCESS);
    }

    public void deleteAnnotationByText(String annotatedText) {
        this.deleteAnnotationByID(this.annotationsLabel.getAnnotationIdByText(annotatedText));
    }

    public String getAnnotationContentByText(String searchText) {
        return this.annotationsLabel.getAnnotationContentByText(searchText);
    }

    public void showAnnotationsPane() {
        this.annotationsPane.showAnnotationsPane();
    }

    public void hideAnnotationsPane() {
        this.annotationsPane.hideAnnotationsPane();
    }

    public void clickShowAnnotations() {
        this.annotationsPane.clickShowAnnotations();
    }

    public void clickHideAnnotations() {
        this.annotationsPane.clickHideAnnotations();
    }

    public boolean checkIfClickbuttonExists() {
        return this.annotationsPane.checkIfShowAnnotationsCheckboxExists();
    }

    public void simulateCTRL_M() {
        WebElement body = this.getDriver().findElement(By.id((String)"body"));
        body.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "m"})});
    }

    public void selectText(String annotationWord) {
        ((JavascriptExecutor)this.getDriver()).executeScript(this.script + "findString('" + annotationWord + "');", new Object[0]);
    }

    public boolean checkIfAnnotationsAreDisabled() {
        return AnnotatableViewPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.id((String)"annotationsdisplay")).size() <= 0;
    }

    public void waitforAnnotationWarningNotification() {
        this.waitForNotificationWarningMessage(XWIKI_SYNTAX_1_WARNING);
    }
}

