/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.test.po;

import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.BaseElement;

public class AnnotationsLabel
extends BaseElement {
    @FindBy(xpath="//a[@title='Delete this annotation']")
    private WebElement deleteAnnotation;
    @FindBy(xpath="//span[@class='annotationAuthor']")
    private WebElement annotationAuthor;
    @FindBy(xpath="annotationDate")
    private WebElement annotationDate;

    private void hoverOnAnnotationByText(String searchText) {
        this.hoverOnAnnotationById(this.getAnnotationIdByText(searchText));
    }

    private void hoverOnAnnotationById(String annotationId) {
        WebElement annotationIcon = this.getDriver().findElement(By.id((String)annotationId));
        Actions builder = new Actions(this.getDriver());
        builder.moveToElement(annotationIcon).build().perform();
        this.waitUntilElementIsVisible(By.className((String)"annotation-box-view"));
    }

    private void showAnnotationById(String idText) {
        this.hoverOnAnnotationById(idText);
    }

    private void showAnnotationByText(String searchText) {
        this.showAnnotationById(this.getAnnotationIdByText(searchText));
    }

    public void deleteAnnotationByText(String searchText) {
        this.deleteAnnotationById(this.getAnnotationIdByText(searchText));
    }

    public void deleteAnnotationById(String idText) {
        this.showAnnotationById(idText);
        this.deleteAnnotation.click();
        this.waitUntilElementIsVisible(By.xpath((String)"//input[@value='Yes']"));
        this.getDriver().findElement(By.xpath((String)"//input[@value='Yes']")).click();
    }

    public String getAnnotationsAuthorByText(String searchText) {
        this.hoverOnAnnotationByText(searchText);
        return this.annotationAuthor.getText();
    }

    public String getAnnotationAuthorById(String idText) {
        this.showAnnotationById(idText);
        return this.annotationAuthor.getText();
    }

    public String getAnnotationIdByText(String searchText) {
        this.waitUntilElementIsVisible(By.xpath((String)("//span[contains(.,'" + searchText + "')]")));
        WebElement annotation = this.getDriver().findElement(By.xpath((String)("//span[contains(.,'" + searchText + "')]")));
        String classId = annotation.getAttribute("class");
        classId = classId.split("\\s+")[1];
        return classId;
    }

    public String getAnnotationContentByText(String searchText) {
        this.hoverOnAnnotationByText(searchText);
        this.waitUntilElementIsVisible(By.xpath((String)"//div[@class='annotationText']/p"));
        String annotationContent = this.getDriver().findElement(By.xpath((String)"//*[@class='annotation-bubble']//div[@class='annotationText']/p")).getText();
        WebElement body = this.getDriver().findElement(By.id((String)"body"));
        body.sendKeys(new CharSequence[]{Keys.ESCAPE});
        body.sendKeys(new CharSequence[]{Keys.ESCAPE});
        this.waitUntilElementDisappears(By.className((String)"annotation-box-view"));
        return annotationContent;
    }
}

