/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManager;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerMessageTool;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerPluginApi;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplicationClass;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

public class ApplicationManagerPlugin
extends XWikiDefaultPlugin
implements EventListener {
    public static final String PLUGIN_NAME = "applicationmanager";
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApplicationManagerPlugin.class);
    private static final List<Event> EVENTS = new ArrayList<Event>(){
        {
            this.add(new DocumentUpdatedEvent());
            this.add(new DocumentCreatedEvent());
        }
    };
    private ApplicationManager applicationManager;

    public ApplicationManagerPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(XWikiContext context) {
        this.applicationManager = new ApplicationManager(ApplicationManagerMessageTool.getDefault(context));
        ((ObservationManager)Utils.getComponent(ObservationManager.class)).addListener((EventListener)this);
        String database = context.getDatabase();
        try {
            XWikiURLFactory urlf = context.getWiki().getURLFactoryService().createURLFactory(context.getMode(), context);
            context.setURLFactory(urlf);
            context.setDatabase(context.getMainXWiki());
            this.applicationManager.updateAllApplicationTranslation(context);
        }
        catch (XWikiException e) {
            LOGGER.error(ApplicationManagerMessageTool.getDefault(context).get("applicationmanager.plugin.log.refreshalltranslations"), (Throwable)e);
        }
        finally {
            context.setDatabase(database);
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        XWikiContext context = (XWikiContext)data;
        try {
            if (XWikiApplicationClass.isApplication(document)) {
                this.applicationManager.updateApplicationsTranslation(document, context);
            }
        }
        catch (XWikiException e) {
            LOGGER.error(ApplicationManagerMessageTool.getDefault(context).get("applicationmanager.plugin.log.autoupdatetranslations", document.getFullName()), (Throwable)e);
        }
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new ApplicationManagerPluginApi((ApplicationManagerPlugin)plugin, context);
    }
}

