/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManager;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerPluginApi;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiURLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.localization.ContextualLocalizationManager;

public class ApplicationManagerPlugin
extends XWikiDefaultPlugin {
    public static final String PLUGIN_NAME = "applicationmanager";
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApplicationManagerPlugin.class);
    private ApplicationManager applicationManager;
    private ContextualLocalizationManager localizationManager = (ContextualLocalizationManager)Utils.getComponent(ContextualLocalizationManager.class);

    public ApplicationManagerPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(XWikiContext context) {
        this.applicationManager = new ApplicationManager();
        String database = context.getDatabase();
        try {
            XWikiURLFactory urlf = context.getWiki().getURLFactoryService().createURLFactory(context.getMode(), context);
            context.setURLFactory(urlf);
            context.setDatabase(context.getMainXWiki());
            this.applicationManager.init(context);
        }
        catch (XWikiException e) {
            LOGGER.error(this.localizationManager.getTranslationPlain("applicationmanager.plugin.log.refreshalltranslations", new Object[0]), (Throwable)e);
        }
        finally {
            context.setDatabase(database);
        }
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new ApplicationManagerPluginApi((ApplicationManagerPlugin)plugin, context);
    }
}

