/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.applicationmanager.doc;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.StringProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.applicationmanager.ApplicationManagerException;
import com.xpn.xwiki.plugin.applicationmanager.core.doc.objects.classes.AbstractXClassManager;
import com.xpn.xwiki.plugin.applicationmanager.doc.XWikiApplication;
import com.xpn.xwiki.web.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.localization.ContextualLocalizationManager;

public class XWikiApplicationClass
extends AbstractXClassManager<XWikiApplication> {
    public static final String DEFAULT_FIELDDT = "input";
    public static final String DEFAULT_FIELDS = "|";
    public static final String FIELD_APPNAME = "appname";
    public static final String FIELDPN_APPNAME = "Application Name";
    public static final String FIELD_APPPRETTYNAME = "appprettyname";
    public static final String FIELDPN_APPPRETTYNAME = "Application Pretty Name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELDPN_DESCRIPTION = "Description";
    public static final String FIELD_APPVERSION = "appversion";
    public static final String FIELDPN_APPVERSION = "Application Version";
    public static final String FIELD_APPAUTHORS = "appauthors";
    public static final String FIELDPN_APPAUTHORS = "Authors";
    public static final String FIELD_LICENSE = "license";
    public static final String FIELDPN_LICENSE = "License";
    public static final String FIELD_DEPENDENCIES = "dependencies";
    public static final String FIELDPN_DEPENDENCIES = "Dependencies";
    public static final String FIELD_APPLICATIONS = "applications";
    public static final String FIELDPN_APPLICATIONS = "Applications";
    public static final String FIELD_DOCUMENTS = "documents";
    public static final String FIELDPN_DOCUMENTS = "Documents";
    public static final String FIELD_DOCSTOINCLUDE = "docstoinclude";
    public static final String FIELDPN_DOCSTOINCLUDE = "Documents to include";
    public static final String FIELD_DOCSTOLINK = "docstolink";
    public static final String FIELDPN_DOCSTOLINK = "Documents to link";
    public static final String FIELD_TRANSLATIONDOCS = "translationdocs";
    public static final String FIELDPN_TRANSLATIONDOCS = "Translations documents";
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiApplicationClass.class);
    private static final String CLASS_SPACE_PREFIX = "XApp";
    private static final String CLASS_PREFIX = "XWikiApplication";
    private static final String DEFAULT_APPLICATION_PARENT = "XAppManager.WebHome";
    private static final String DEFAULT_APPLICATION_VERSION = "1.0";
    private static XWikiApplicationClass instance;
    private ContextualLocalizationManager localizationManager = (ContextualLocalizationManager)Utils.getComponent(ContextualLocalizationManager.class);

    protected XWikiApplicationClass() {
        super(CLASS_SPACE_PREFIX, CLASS_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XWikiApplicationClass getInstance(XWikiContext context, boolean check) throws XWikiException {
        Class<XWikiApplicationClass> clazz = XWikiApplicationClass.class;
        synchronized (XWikiApplicationClass.class) {
            if (instance == null) {
                instance = new XWikiApplicationClass();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (check) {
                instance.check(context);
            }
            return instance;
        }
    }

    public static XWikiApplicationClass getInstance(XWikiContext context) throws XWikiException {
        return XWikiApplicationClass.getInstance(context, true);
    }

    public static boolean isApplication(XWikiDocument doc) {
        boolean isApplication = false;
        try {
            XWikiApplicationClass xclass = XWikiApplicationClass.getInstance(null, false);
            isApplication = xclass.isInstance(doc);
        }
        catch (XWikiException e) {
            LOGGER.error("Fail to get unique instance of " + XWikiApplicationClass.class.getName(), (Throwable)e);
        }
        return isApplication;
    }

    @Override
    protected boolean updateBaseClass(BaseClass baseClass) {
        boolean needsUpdate = super.updateBaseClass(baseClass);
        needsUpdate |= baseClass.addTextField(FIELD_APPNAME, FIELDPN_APPNAME, 80);
        needsUpdate |= baseClass.addTextField(FIELD_APPPRETTYNAME, FIELDPN_APPPRETTYNAME, 30);
        needsUpdate |= baseClass.addTextAreaField(FIELD_DESCRIPTION, FIELDPN_DESCRIPTION, 40, 5);
        needsUpdate |= baseClass.addTextField(FIELD_APPVERSION, FIELDPN_APPVERSION, 30);
        needsUpdate |= baseClass.addTextField(FIELD_APPAUTHORS, FIELDPN_APPAUTHORS, 30);
        needsUpdate |= baseClass.addTextField(FIELD_LICENSE, FIELDPN_LICENSE, 30);
        needsUpdate |= baseClass.addStaticListField(FIELD_DEPENDENCIES, FIELDPN_DEPENDENCIES, 80, true, "", DEFAULT_FIELDDT, DEFAULT_FIELDS);
        needsUpdate |= baseClass.addStaticListField(FIELD_APPLICATIONS, FIELDPN_APPLICATIONS, 80, true, "", DEFAULT_FIELDDT, DEFAULT_FIELDS);
        needsUpdate |= baseClass.addStaticListField(FIELD_DOCUMENTS, FIELDPN_DOCUMENTS, 80, true, "", DEFAULT_FIELDDT, DEFAULT_FIELDS);
        needsUpdate |= baseClass.addStaticListField(FIELD_DOCSTOINCLUDE, FIELDPN_DOCSTOINCLUDE, 80, true, "", DEFAULT_FIELDDT, DEFAULT_FIELDS);
        needsUpdate |= baseClass.addStaticListField(FIELD_DOCSTOLINK, FIELDPN_DOCSTOLINK, 80, true, "", DEFAULT_FIELDDT, DEFAULT_FIELDS);
        return needsUpdate |= baseClass.addStaticListField(FIELD_TRANSLATIONDOCS, FIELDPN_TRANSLATIONDOCS, 80, true, "", DEFAULT_FIELDDT, DEFAULT_FIELDS);
    }

    @Override
    protected boolean updateClassTemplateDocument(XWikiDocument doc) {
        boolean needsUpdate = false;
        if (!DEFAULT_APPLICATION_PARENT.equals(doc.getParent())) {
            doc.setParent(DEFAULT_APPLICATION_PARENT);
            needsUpdate = true;
        }
        return needsUpdate |= this.updateDocStringValue(doc, FIELD_APPVERSION, DEFAULT_APPLICATION_VERSION);
    }

    protected XWikiDocument getApplicationDocument(String appName, XWikiContext context, boolean validate) throws XWikiException {
        XWiki xwiki = context.getWiki();
        Object[][] fieldDescriptors = new String[][]{{FIELD_APPNAME, StringProperty.class.getSimpleName(), appName}};
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        String where = this.createWhereClause(fieldDescriptors, parameterValues);
        List listApp = context.getWiki().getStore().searchDocuments(where, parameterValues, context);
        if (listApp.isEmpty()) {
            if (validate) {
                throw new ApplicationManagerException(60011, this.localizationManager.getTranslationPlain("applicationmanager.plugin.error.applicationdoesnotexists", new Object[]{appName}));
            }
            return xwiki.getDocument(this.getItemDocumentDefaultFullName(appName, context), context);
        }
        return (XWikiDocument)listApp.get(0);
    }

    public XWikiApplication getApplication(String appName, boolean validate, XWikiContext context) throws XWikiException {
        BaseObject obj;
        XWikiDocument doc = this.getApplicationDocument(appName, context, validate);
        int objectId = 0;
        Iterator i$ = doc.getObjects(this.getClassFullName()).iterator();
        while (i$.hasNext() && !(obj = (BaseObject)i$.next()).getStringValue(FIELD_APPNAME).equalsIgnoreCase(appName)) {
            ++objectId;
        }
        if (objectId == doc.getObjects(this.getClassFullName()).size()) {
            objectId = 0;
        }
        return this.newXObjectDocument(doc, objectId, context);
    }

    @Override
    public XWikiApplication newXObjectDocument(XWikiDocument doc, int objId, XWikiContext context) throws XWikiException {
        return new XWikiApplication(doc, objId, context);
    }
}

