/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.appwithinminutes.test.po;

import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.xwiki.appwithinminutes.test.po.ApplicationCreatePage;
import org.xwiki.appwithinminutes.test.po.ApplicationHomeEditPage;
import org.xwiki.appwithinminutes.test.po.ClassFieldEditPane;
import org.xwiki.test.ui.po.InlinePage;
import org.xwiki.test.ui.po.ViewPage;

public class ApplicationClassEditPage
extends InlinePage {
    @FindBy(id="wizard-next")
    private WebElement nextStepButton;
    @FindBy(linkText="PREVIOUS STEP")
    private WebElement previousStepButton;
    @FindBy(name="xaction_save")
    private WebElement saveButton;
    @FindBy(name="xaction_saveandcontinue")
    private WebElement saveAndContinueButton;
    @FindBy(id="palette")
    private WebElement palette;
    @FindBy(id="fields")
    private WebElement fields;
    @FindBy(id="updateClassSheet")
    private WebElement updateClassSheetCheckbox;

    public ApplicationHomeEditPage clickNextStep() {
        this.nextStepButton.click();
        return new ApplicationHomeEditPage();
    }

    public ApplicationCreatePage clickPreviousStep() {
        this.previousStepButton.click();
        return new ApplicationCreatePage();
    }

    public boolean hasPreviousStep() {
        return ApplicationClassEditPage.getUtil().findElementsWithoutWaiting(this.getDriver(), By.linkText((String)"PREVIOUS STEP")).size() > 0;
    }

    public <T extends ViewPage> T clickSaveAndView() {
        this.saveButton.click();
        return (T)this.createViewPage();
    }

    public void clickSaveAndContinue() {
        this.saveAndContinueButton.click();
    }

    public ClassFieldEditPane addField(String fieldType) {
        String fieldXPath = "//span[@class = 'field' and normalize-space(.) = '%s']";
        WebElement field = this.palette.findElement(By.xpath((String)String.format(fieldXPath, fieldType)));
        int fieldCount = ApplicationClassEditPage.getUtil().findElementsWithoutWaiting(this.getDriver(), this.fields, By.xpath((String)"li")).size();
        this.palette.sendKeys(new CharSequence[]{Keys.HOME});
        new Actions(this.getDriver()).dragAndDrop(field, this.fields).perform();
        final WebElement addedField = this.fields.findElement(By.xpath((String)("li[" + (fieldCount + 1) + "]")));
        ApplicationClassEditPage.getUtil().waitUntilCondition((ExpectedCondition)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return !addedField.getAttribute("class").contains("loading");
                }
                catch (NotFoundException e) {
                    return false;
                }
                catch (StaleElementReferenceException e) {
                    return false;
                }
            }
        });
        return new ClassFieldEditPane(addedField.getAttribute("id").substring("field-".length()));
    }

    public void moveFieldBefore(String fieldToMove, String beforeField) {
        new ClassFieldEditPane(fieldToMove).dragTo(this.fields.findElement(By.id((String)("field-" + beforeField))), 1, -3);
    }

    public void setUpdateClassSheet(boolean update) {
        if (this.updateClassSheetCheckbox.isSelected() != update) {
            this.updateClassSheetCheckbox.click();
        }
    }
}

