/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.appwithinminutes.test.po;

import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.xwiki.test.ui.po.BaseElement;
import org.xwiki.test.ui.po.ConfirmationBox;

public class ClassFieldEditPane
extends BaseElement {
    private final String fieldName;
    private final WebElement container;
    private final WebElement toolBox;

    public ClassFieldEditPane(String fieldName) {
        this.fieldName = fieldName;
        this.container = this.getDriver().findElement(By.id((String)("field-" + fieldName)));
        this.toolBox = this.container.findElement(By.className((String)"toolBox"));
    }

    public void setPrettyName(String prettyName) {
        WebElement prettyNameInput = this.getPropertyInput("prettyName");
        prettyNameInput.clear();
        prettyNameInput.sendKeys(new CharSequence[]{prettyName});
    }

    public void setDefaultValue(String defaultValue) {
        WebElement defaultValueInput = this.getDefaultValueInput();
        defaultValueInput.clear();
        defaultValueInput.sendKeys(new CharSequence[]{defaultValue});
    }

    public String getDefaultValue() {
        return this.getDefaultValueInput().getAttribute("value");
    }

    protected WebElement getDefaultValueInput() {
        String xpath = "//*[substring(@id, string-length(@id) - %s - 2) = '_0_%s']";
        return this.container.findElement(By.xpath((String)String.format(xpath, this.fieldName.length(), this.fieldName)));
    }

    public void openConfigPanel() {
        this.clickToolBoxIcon("Configure");
    }

    public void closeConfigPanel() {
        this.clickToolBoxIcon("Preview");
        String previewXPath = "//*[@id = 'field-" + this.fieldName + "']//dl[@class = 'field-viewer']/dd";
        this.waitUntilElementHasAttributeValue(By.xpath((String)previewXPath), "class", "");
    }

    private void clickToolBoxIcon(String alt) {
        new Actions(this.getDriver()).moveToElement(this.container).perform();
        this.showToolBox();
        this.toolBox.findElement(By.xpath((String)("img[@alt = '" + alt + "']"))).click();
        this.hideToolBox();
    }

    private void showToolBox() {
        ((JavascriptExecutor)this.getDriver()).executeScript("arguments[0].style.display = 'block';", new Object[]{this.toolBox});
    }

    private void hideToolBox() {
        ((JavascriptExecutor)this.getDriver()).executeScript("arguments[0].style.display = '';", new Object[]{this.toolBox});
    }

    public void setName(String fieldName) {
        WebElement nameInput = this.getPropertyInput("name");
        nameInput.clear();
        nameInput.sendKeys(new CharSequence[]{fieldName});
    }

    public String getName() {
        return this.getPropertyInput("name").getAttribute("value");
    }

    protected WebElement getPropertyInput(String propertyName) {
        return this.container.findElement(By.id((String)String.format("field-%s_%s", this.fieldName, propertyName)));
    }

    public ConfirmationBox delete() {
        this.clickToolBoxIcon("Delete");
        return new ConfirmationBox();
    }

    public void dragTo(WebElement element, int xOffset, int yOffset) {
        new Actions(this.getDriver()).moveToElement(this.container).perform();
        this.showToolBox();
        WebElement dragHandler = this.toolBox.findElement(By.xpath((String)"img[@alt = 'Move']"));
        new Actions(this.getDriver()).clickAndHold(dragHandler).moveToElement(element, xOffset, yOffset).release().perform();
        this.hideToolBox();
    }

    protected WebElement getContainer() {
        return this.container;
    }

    protected String getFieldName() {
        return this.fieldName;
    }
}

