/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.appwithinminutes.test.po;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.xwiki.test.ui.po.InlinePage;

public class EntryEditPage
extends InlinePage {
    private static final String LABEL_XPATH_FORMAT = "//label[substring(@for, string-length(@for) - %s - 2) = '_0_%s']";
    private static final String FIELD_XPATH_FORMAT = "//*[substring(@id, string-length(@id) - %s - 2) = '_0_%s']";

    public String getLabel(String fieldName) {
        String xpath = String.format(LABEL_XPATH_FORMAT, fieldName.length(), fieldName);
        WebElement label = this.getForm().findElement(By.xpath((String)xpath));
        return label.getText();
    }

    public String getValue(String fieldName) {
        String xpath = String.format(FIELD_XPATH_FORMAT, fieldName.length(), fieldName);
        WebElement field = this.getForm().findElement(By.xpath((String)xpath));
        return field.getAttribute("value");
    }

    public void setValue(String fieldName, String fieldValue) {
        String xpath = String.format(FIELD_XPATH_FORMAT, fieldName.length(), fieldName);
        WebElement field = this.getForm().findElement(By.xpath((String)xpath));
        field.clear();
        field.sendKeys(new CharSequence[]{fieldValue});
    }

    public List<String> getFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (WebElement field : this.getForm().findElements(By.xpath((String)"//*[contains(@name, '_0_')]"))) {
            fieldNames.add(StringUtils.substringAfter((String)field.getAttribute("name"), (String)"_0_"));
        }
        return fieldNames;
    }
}

