/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.appwithinminutes.test.po;

import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.xwiki.test.ui.po.BaseElement;

public class StaticListItemsEditor
extends BaseElement {
    private WebElement container;
    private WebElement valueInput;
    private WebElement labelInput;
    private WebElement addButton;

    public StaticListItemsEditor(WebElement container) {
        this.container = container;
        By xpath = By.xpath((String)".//*[@class = 'xHint' and . = 'ID']/following-sibling::input[@type = 'text']");
        this.valueInput = StaticListItemsEditor.getUtil().findElementWithoutWaiting(this.getDriver(), container, xpath);
        xpath = By.xpath((String)".//*[@class = 'xHint' and . = 'Value']/following-sibling::input[@type = 'text']");
        this.labelInput = StaticListItemsEditor.getUtil().findElementWithoutWaiting(this.getDriver(), container, xpath);
        this.addButton = StaticListItemsEditor.getUtil().findElementWithoutWaiting(this.getDriver(), container, By.className((String)"add"));
    }

    public void remove(String value) {
        By xpath = By.xpath((String)("ul/li/*[@title = '" + value + "']/following-sibling::*[@class = 'delete']"));
        StaticListItemsEditor.getUtil().findElementWithoutWaiting(this.getDriver(), this.container, xpath).click();
    }

    public void add(String value, String label) {
        this.valueInput.clear();
        this.valueInput.sendKeys(new CharSequence[]{value});
        this.labelInput.clear();
        this.labelInput.sendKeys(new CharSequence[]{label});
        this.addButton.click();
    }

    public WebElement getValueInput() {
        return this.valueInput;
    }

    public WebElement getLabelInput() {
        return this.labelInput;
    }

    public void setLabel(String value, String newLabel) {
        this.getItem(value).click();
        this.labelInput.clear();
        this.labelInput.sendKeys(new CharSequence[]{newLabel + Keys.RETURN});
    }

    public void moveBefore(String valueToMove, String beforeValue) {
        new Actions(this.getDriver()).clickAndHold(this.getItem(valueToMove)).moveToElement(this.getItem(beforeValue), -3, 0).release().perform();
    }

    public WebElement getItem(String valueOrLabel) {
        By xpath = By.xpath((String)("ul/li/*[@title = '" + valueOrLabel + "' or . = '" + valueOrLabel + "']"));
        return StaticListItemsEditor.getUtil().findElementWithoutWaiting(this.getDriver(), this.container, xpath);
    }

    public int size() {
        return StaticListItemsEditor.getUtil().findElementsWithoutWaiting(this.getDriver(), this.container, By.tagName((String)"li")).size();
    }
}

