/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.internal;

import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheFactory;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.CacheManagerConfiguration;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class DefaultCacheManager
implements CacheManager {
    @Requirement
    private ComponentManager componentManager;
    @Requirement
    private CacheManagerConfiguration configuration;

    @Override
    public CacheFactory getCacheFactory() throws ComponentLookupException {
        return this.getCacheFactory(this.configuration.getDefaultCache());
    }

    @Override
    public CacheFactory getLocalCacheFactory() throws ComponentLookupException {
        return this.getCacheFactory(this.configuration.getDefaultLocalCache());
    }

    public CacheFactory getCacheFactory(String cacheHint) throws ComponentLookupException {
        return (CacheFactory)this.componentManager.lookup(CacheFactory.class, cacheHint);
    }

    @Override
    public <T> Cache<T> createNewCache(CacheConfiguration config) throws CacheException {
        return this.createNewCache(config, this.configuration.getDefaultCache());
    }

    @Override
    public <T> Cache<T> createNewLocalCache(CacheConfiguration config) throws CacheException {
        return this.createNewCache(config, this.configuration.getDefaultLocalCache());
    }

    public <T> Cache<T> createNewCache(CacheConfiguration config, String cacheHint) throws CacheException {
        CacheFactory cacheFactory;
        try {
            cacheFactory = (CacheFactory)this.componentManager.lookup(CacheFactory.class, cacheHint);
        }
        catch (ComponentLookupException e) {
            throw new CacheException("Failed to get cache factory for role hint [" + cacheHint + "]", e);
        }
        return cacheFactory.newCache(config);
    }
}

