/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.calendar;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.DateProperty;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.StringListProperty;
import com.xpn.xwiki.objects.StringProperty;
import com.xpn.xwiki.plugin.calendar.CalendarEvent;
import com.xpn.xwiki.render.XWikiVelocityRenderer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;

public class CalendarData {
    private Map cdata = new HashMap();

    public CalendarData() {
    }

    public CalendarData(String user, XWikiContext context) throws XWikiException {
        this.addCalendarData(context.getDoc(), user, context);
    }

    public CalendarData(XWikiDocument doc, String user, XWikiContext context) throws XWikiException {
        this.addCalendarData(doc, user, context);
    }

    public CalendarData(String hql, String user, XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        List list = xwiki.getStore().searchDocumentsNames(hql, context);
        for (int i = 0; i < list.size(); ++i) {
            String docname = (String)list.get(i);
            XWikiDocument doc = xwiki.getDocument(docname, context);
            this.addCalendarData(doc, user, context);
        }
    }

    public CalendarData(String hql, int nb, XWikiContext context) throws XWikiException {
        XWiki xwiki = context.getWiki();
        List list = xwiki.getStore().searchDocumentsNames(hql, nb, 0, context);
        SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
        for (int i = 0; i < list.size(); ++i) {
            String docname = (String)list.get(i);
            XWikiDocument doc = xwiki.getDocument(docname, context);
            Date date = doc.getDate();
            Calendar cdate = Calendar.getInstance();
            cdate.setTime(date);
            this.cdata.put(df.format(date), new CalendarEvent(cdate, cdate, "", "[" + doc.getDisplayTitle(context) + ">" + doc.getFullName() + "] by " + context.getWiki().getLocalUserName(doc.getAuthor(), context)));
        }
    }

    public List getCalendarData() {
        ArrayList ldata = new ArrayList();
        ArrayList sortedKeys = new ArrayList(this.cdata.keySet());
        Collections.sort(sortedKeys);
        Iterator it = sortedKeys.iterator();
        while (it.hasNext()) {
            ldata.addAll((List)this.cdata.get(it.next()));
        }
        return ldata;
    }

    public Map getMappedCalendarData() {
        return this.cdata;
    }

    public List getCalendarData(Calendar date) {
        Object result = this.cdata.get(new SimpleDateFormat("yyMMdd").format(date.getTime()));
        if (result == null) {
            result = new ArrayList();
        }
        return (List)result;
    }

    public void addCalendarData(XWikiDocument doc, String defaultUser, XWikiContext context) throws XWikiException {
        if (doc == null) {
            return;
        }
        if (!context.getWiki().getRightService().hasAccessLevel("view", context.getUser(), doc.getFullName(), context)) {
            return;
        }
        if (defaultUser == null) {
            BaseObject bobj = doc.getObject("XWiki.XWikiUsers");
            defaultUser = bobj == null ? doc.getCreator() : doc.getFullName();
        }
        String defaultDescription = "";
        String defaultURL = "";
        defaultDescription = "[" + doc.getDisplayTitle(context) + ">" + doc.getFullName() + "]";
        defaultURL = doc.getURL("view", context);
        Vector bobjs = doc.getObjects("XWiki.CalendarEvent");
        if (bobjs != null) {
            for (int i = 0; i < bobjs.size(); ++i) {
                try {
                    BaseObject bobj = (BaseObject)bobjs.get(i);
                    String user = "";
                    try {
                        user = ((StringProperty)bobj.get("user")).getValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    String description = "";
                    try {
                        description = ((LargeStringProperty)bobj.get("description")).getValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    String title = "";
                    try {
                        title = ((StringProperty)bobj.get("title")).getValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (StringUtils.isBlank((String)title)) {
                        title = doc.getDisplayTitle(context);
                    }
                    String url = "";
                    try {
                        url = ((StringProperty)bobj.get("url")).getValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    String location = "";
                    try {
                        location = ((StringProperty)bobj.get("location")).getValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    List category = null;
                    try {
                        category = (List)((StringListProperty)bobj.get("category")).getValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Date dateStart = null;
                    try {
                        dateStart = (Date)((DateProperty)bobj.get("startDate")).getValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Date dateEnd = null;
                    try {
                        dateEnd = (Date)((DateProperty)bobj.get("endDate")).getValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (user == null || user.equals("")) {
                        user = defaultUser;
                    }
                    if (dateStart == null) {
                        dateStart = dateEnd;
                    }
                    if (dateEnd == null) {
                        dateEnd = dateStart;
                    }
                    if (dateStart == null || dateEnd == null) continue;
                    if (dateStart.getTime() > dateEnd.getTime()) {
                        Date dateTemp = dateStart;
                        dateStart = dateEnd;
                        dateEnd = dateTemp;
                    }
                    if (description == null || description.equals("")) {
                        description = defaultDescription;
                    }
                    if (url == null || url.equals("")) {
                        url = defaultURL;
                    }
                    Calendar cdateStart = Calendar.getInstance();
                    cdateStart.setTime(dateStart);
                    Calendar cdateEnd = Calendar.getInstance();
                    cdateEnd.setTime(dateEnd);
                    this.addCalendarData(new CalendarEvent(cdateStart, cdateEnd, user, description, title, category, url, location));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getContent(Calendar tddate, XWikiContext context) {
        return this.getContent(tddate, null, null, null, context);
    }

    public String getContent(Calendar tddate, String filteredUser, String filteredLocation, List filteredCategories, XWikiContext context) {
        StringBuffer result = new StringBuffer();
        for (CalendarEvent event : this.getCalendarData(tddate)) {
            ArrayList categories;
            String user = event.getUser();
            if (!StringUtils.isBlank((String)filteredUser) && !filteredUser.trim().equals(user)) continue;
            String location = event.getLocation();
            if (!StringUtils.isBlank((String)filteredLocation) && !filteredLocation.trim().equals(location)) continue;
            if (filteredCategories != null && filteredCategories.size() > 0) {
                categories = new ArrayList(event.getCategory());
                categories.retainAll(filteredCategories);
                if (categories.size() <= 0) continue;
            }
            categories = event.getCategory();
            String title = event.getTitle();
            String url = event.getUrl();
            result.append("<div class=\"event");
            if (categories != null && categories.size() > 0) {
                Iterator cit = categories.iterator();
                while (cit.hasNext()) {
                    result.append(" " + cit.next());
                }
            }
            result.append("\">");
            if (!StringUtils.isBlank((String)user)) {
                result.append("<span class=\"username\">" + context.getWiki().getLocalUserName(event.getUser(), context) + "</span>");
            }
            if (!StringUtils.isBlank((String)user) && !StringUtils.isBlank((String)title)) {
                result.append(": ");
            }
            if (!StringUtils.isBlank((String)url)) {
                result.append("<a href=\"" + url + "\">");
            }
            result.append(title);
            if (!StringUtils.isBlank((String)url)) {
                result.append("</a>");
            }
            result.append("</div>");
        }
        return result.toString();
    }

    public String getContent(Calendar tddate, String velocityScript, XWikiContext context) {
        VelocityContext vcontext = new VelocityContext();
        vcontext.put("date", (Object)tddate);
        List events = this.getCalendarData(tddate);
        vcontext.put("events", (Object)events);
        return XWikiVelocityRenderer.evaluate((String)velocityScript, (String)"<calendar displaying code>", (VelocityContext)vcontext, (XWikiContext)context);
    }

    public void addCalendarData(CalendarEvent event) {
        SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
        Calendar cdateStart = event.getDateStart();
        String dateEnd = df.format(event.getDateEnd().getTime());
        Calendar crtDate = (Calendar)cdateStart.clone();
        do {
            ArrayList<CalendarEvent> evtList;
            if ((evtList = (ArrayList<CalendarEvent>)this.cdata.get(df.format(crtDate.getTime()))) == null) {
                evtList = new ArrayList<CalendarEvent>();
            }
            evtList.add(event);
            this.cdata.put(df.format(crtDate.getTime()), evtList);
            crtDate.add(5, 1);
        } while (df.format(crtDate.getTime()).compareTo(dateEnd) <= 0);
    }

    public void addCalendarData(Calendar dateStart, Calendar dateEnd, String user, String description) {
        this.addCalendarData(new CalendarEvent(dateStart, dateEnd, user, description));
    }

    public void addCalendarData(Date dateStart, Date dateEnd, String user, String description) {
        Calendar cdateStart = Calendar.getInstance();
        cdateStart.setTime(dateStart);
        Calendar cdateEnd = Calendar.getInstance();
        cdateEnd.setTime(dateEnd);
        this.addCalendarData(cdateStart, cdateEnd, user, description);
    }
}

