/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.captcha.internal;

import com.octo.captcha.engine.CaptchaEngine;
import com.octo.captcha.service.CaptchaService;
import com.octo.captcha.service.captchastore.CaptchaStore;
import com.octo.captcha.service.captchastore.FastHashMapCaptchaStore;
import com.octo.captcha.service.multitype.GenericManageableCaptchaService;
import javax.inject.Singleton;
import org.xwiki.captcha.CaptchaException;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;

@Component(roles={CaptchaServiceManager.class})
@Singleton
public class CaptchaServiceManager
implements Initializable {
    private CaptchaStore captchaStore;

    public void initialize() throws InitializationException {
        this.captchaStore = new FastHashMapCaptchaStore();
    }

    public CaptchaStore getCaptchaStore() {
        return this.captchaStore;
    }

    public CaptchaService getCaptchaService(String engine) throws CaptchaException {
        GenericManageableCaptchaService result = null;
        CaptchaEngine captchaEngine = null;
        try {
            Class<?> engineClass = Class.forName(engine);
            captchaEngine = (CaptchaEngine)engineClass.getConstructor(null).newInstance(null);
        }
        catch (Exception e) {
            throw new CaptchaException(String.format("Invalid engine [%s]", engine), (Throwable)e);
        }
        result = new GenericManageableCaptchaService(this.captchaStore, captchaEngine, 180, 100000, 75000);
        return result;
    }
}

