/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.captcha.internal;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.captcha.internal.JCaptchaResourceReference;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLNormalizer;

@Component
@Singleton
public class JCaptchaResourceReferenceSerializer
implements ResourceReferenceSerializer<JCaptchaResourceReference, ExtendedURL> {
    @Inject
    @Named(value="contextpath")
    private URLNormalizer<ExtendedURL> extendedURLNormalizer;

    public ExtendedURL serialize(JCaptchaResourceReference resource) throws SerializeResourceReferenceException, UnsupportedResourceReferenceException {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add("jcaptcha");
        segments.add(resource.getCaptchaType());
        segments.add(resource.getEngine());
        ExtendedURL extendedURL = new ExtendedURL(segments, resource.getParameters());
        return (ExtendedURL)this.extendedURLNormalizer.normalize(extendedURL);
    }
}

