/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal.source;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.chart.internal.source.AbstractTableBlockDataSource;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.TableBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.parser.Parser;

@Component
@Named(value="xdom")
@Singleton
public class DocumentTableBlockDataSource
extends AbstractTableBlockDataSource {
    private static final String DOCUMENT = "document";
    private static final String TABLE = "table";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private DocumentAccessBridge docBridge;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    @Override
    protected TableBlock getTableBlock(String macroContent, Map<String, String> macroParameters) throws MacroExecutionException {
        XDOM xdom;
        String documentName = macroParameters.get(DOCUMENT);
        if (null == documentName) {
            documentName = (String)this.entityReferenceSerializer.serialize((EntityReference)this.docBridge.getCurrentDocumentReference(), new Object[0]);
        }
        if (!this.docBridge.exists(documentName)) {
            throw new MacroExecutionException(String.format("Document [%s] does not exist.", documentName));
        }
        try {
            Parser parser = (Parser)this.componentManager.lookup(Parser.class, this.docBridge.getDocumentSyntaxId(documentName));
            xdom = parser.parse((Reader)new StringReader(this.docBridge.getDocumentContent(documentName)));
        }
        catch (Exception ex) {
            throw new MacroExecutionException(String.format("Error while parsing document: [%s].", documentName), (Throwable)ex);
        }
        List tableBlocks = xdom.getBlocks((BlockMatcher)new ClassBlockMatcher(TableBlock.class), Block.Axes.DESCENDANT);
        String tableId = macroParameters.get(TABLE);
        TableBlock result = null;
        if (null != tableId) {
            for (TableBlock tableBlock : tableBlocks) {
                String id = tableBlock.getParameter("id");
                if (null == id || !id.equals(tableId)) continue;
                result = tableBlock;
                break;
            }
        } else {
            TableBlock tableBlock = result = tableBlocks.size() > 0 ? (TableBlock)tableBlocks.get(0) : null;
        }
        if (null == result) {
            throw new MacroExecutionException("Unable to find a macthing data table.");
        }
        return result;
    }
}

