/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.chart.source;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.LocaleUtils;
import org.xwiki.rendering.internal.macro.chart.source.AbstractConfigurator;
import org.xwiki.rendering.macro.MacroExecutionException;

public class LocaleConfiguration
extends AbstractConfigurator {
    public static final String LOCALE_PARAM = "locale";
    public static final String DATEFORMAT_PARAM = "date_format";
    private Locale locale = Locale.getDefault();
    private TimeZone timeZone = TimeZone.getDefault();
    private DateFormat dateFormat = DateFormat.getInstance();
    private String dateFormatString;

    @Override
    public boolean setParameter(String key, String value) throws MacroExecutionException {
        boolean claimed = true;
        if (LOCALE_PARAM.equals(key)) {
            boolean valid = true;
            try {
                Locale l = LocaleUtils.toLocale((String)value);
                if (!LocaleUtils.isAvailableLocale((Locale)l)) {
                    valid = false;
                } else {
                    this.locale = l;
                }
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
            if (!valid) {
                throw new MacroExecutionException(String.format("Invalid locale string [%s].", value));
            }
        } else if (DATEFORMAT_PARAM.equals(key)) {
            this.dateFormatString = value;
        } else {
            claimed = false;
        }
        return claimed;
    }

    @Override
    public void validateParameters() throws MacroExecutionException {
        try {
            if (this.dateFormatString != null) {
                this.dateFormat = new SimpleDateFormat(this.dateFormatString, this.locale);
            }
        }
        catch (IllegalArgumentException e) {
            throw new MacroExecutionException(String.format("Invalid date format [%s].", this.dateFormatString));
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }
}

