/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.chart.source.table;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.TableBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.internal.macro.chart.source.table.AbstractTableBlockDataSource;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="xdom")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentTableBlockDataSource
extends AbstractTableBlockDataSource {
    private static final String DOCUMENT_PARAM = "document";
    private static final String TABLE_PARAM = "table";
    private DocumentReference documentReference;
    private String tableId;
    @Inject
    private Logger logger;
    @Inject
    private DocumentDisplayer documentDisplayer;
    @Inject
    private DocumentAccessBridge docBridge;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private AuthorizationManager authorizationManager;

    @Override
    protected TableBlock getTableBlock(String macroContent, MacroTransformationContext context) throws MacroExecutionException {
        XDOM xdom = this.computeXDOM(context);
        List tableBlocks = xdom.getBlocks((BlockMatcher)new ClassBlockMatcher(TableBlock.class), Block.Axes.DESCENDANT);
        TableBlock result = null;
        this.logger.debug("Table id is [{}], there are [{}] tables in the document [{}]", new Object[]{this.tableId, tableBlocks.size(), this.documentReference});
        if (null != this.tableId) {
            for (TableBlock tableBlock : tableBlocks) {
                String id = tableBlock.getParameter("id");
                if (null == id || !id.equals(this.tableId)) continue;
                result = tableBlock;
                break;
            }
        } else {
            TableBlock tableBlock = result = tableBlocks.size() > 0 ? (TableBlock)tableBlocks.get(0) : null;
        }
        if (null == result) {
            throw new MacroExecutionException("Unable to find a matching data table.");
        }
        return result;
    }

    private XDOM computeXDOM(MacroTransformationContext context) throws MacroExecutionException {
        XDOM xdom;
        if (this.isDefinedChartSourceTheCurrentDocument(context.getCurrentMacroBlock())) {
            xdom = context.getXDOM();
        } else {
            try {
                DocumentModelBridge document = this.docBridge.getDocument(this.documentReference);
                DocumentDisplayerParameters parameters = new DocumentDisplayerParameters();
                parameters.setContentTranslated(true);
                parameters.setTargetSyntax(context.getTransformationContext().getTargetSyntax());
                xdom = this.documentDisplayer.display((Object)document, (Object)parameters);
            }
            catch (Exception e) {
                throw new MacroExecutionException(String.format("Error getting Chart table from document [%s]", this.documentReference, e));
            }
        }
        return xdom;
    }

    protected boolean isDefinedChartSourceTheCurrentDocument(MacroBlock currentMacroBlock) {
        boolean result;
        if (this.documentReference == null) {
            result = true;
        } else {
            String sourceReference = this.extractSourceContentReference((Block)currentMacroBlock);
            result = this.documentReferenceResolver.resolve((Object)sourceReference, new Object[]{this.docBridge.getCurrentDocumentReference()}).equals((Object)this.documentReference);
        }
        return result;
    }

    @Override
    protected boolean setParameter(String key, String value) throws MacroExecutionException {
        if (DOCUMENT_PARAM.equals(key)) {
            this.documentReference = this.documentReferenceResolver.resolve((Object)value, new Object[]{this.docBridge.getCurrentDocumentReference()});
            return true;
        }
        if (TABLE_PARAM.equals(key)) {
            this.tableId = value;
            return true;
        }
        return super.setParameter(key, value);
    }

    @Override
    protected void validateParameters() throws MacroExecutionException {
        super.validateParameters();
        if (this.documentReference != null) {
            if (!this.authorizationManager.hasAccess(Right.VIEW, this.docBridge.getCurrentUserReference(), (EntityReference)this.documentReference)) {
                throw new MacroExecutionException("You do not have permission to view the document.");
            }
            if (!this.docBridge.exists(this.documentReference)) {
                throw new MacroExecutionException(String.format("Document [%s] does not exist.", this.documentReference));
            }
        }
    }

    private String extractSourceContentReference(Block source) {
        String contentSource = null;
        MetaDataBlock metaDataBlock = (MetaDataBlock)source.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("source"), Block.Axes.ANCESTOR);
        if (metaDataBlock != null) {
            contentSource = (String)metaDataBlock.getMetaData().getMetaData("source");
        }
        return contentSource;
    }
}

