/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.source;

import com.xpn.xwiki.plugin.charts.exceptions.ColumnIndexOutOfBoundsException;
import com.xpn.xwiki.plugin.charts.exceptions.DataSourceException;
import com.xpn.xwiki.plugin.charts.exceptions.NoHeaderColumnException;
import com.xpn.xwiki.plugin.charts.exceptions.NoHeaderRowException;
import com.xpn.xwiki.plugin.charts.exceptions.RowIndexOutOfBoundsException;
import com.xpn.xwiki.plugin.charts.source.DataSource;

public class DefaultDataSource
implements DataSource {
    protected Number[][] data;
    protected String[] headerRow;
    protected String[] headerColumn;

    public DefaultDataSource() {
        this.data = new Number[0][0];
    }

    public DefaultDataSource(Number[][] data) {
        this.data = data;
    }

    public DefaultDataSource(Number[][] data, String[] headerRow, String[] headerColumn) {
        if (headerColumn != null && headerColumn.length != data.length) {
            throw new IllegalArgumentException("headerColumn.length != data.length");
        }
        for (int i = 0; i < data.length; ++i) {
            if (headerRow != null && headerRow.length != data[i].length) {
                throw new IllegalArgumentException("headerRow.length != data[" + i + "].length");
            }
            if (headerRow != null || i <= 0 || data[i].length == data[i - 1].length) continue;
            throw new IllegalArgumentException("data[" + i + "].length != data[" + (i - 1) + "].length");
        }
        this.data = data;
        this.headerColumn = headerColumn;
        this.headerRow = headerRow;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public int getColumnCount() {
        if (this.data.length > 0) {
            return this.data[0].length;
        }
        return 0;
    }

    @Override
    public Number getCell(int rowIndex, int colIndex) throws DataSourceException {
        this.checkRowIndex(rowIndex);
        this.checkColumnIndex(colIndex);
        return this.data[rowIndex][colIndex];
    }

    public void setCell(int rowIndex, int colIndex, Number content) throws DataSourceException {
        this.checkRowIndex(rowIndex);
        this.checkColumnIndex(colIndex);
        this.data[rowIndex][colIndex] = content;
    }

    @Override
    public Number[] getRow(int rowIndex) throws DataSourceException {
        this.checkRowIndex(rowIndex);
        return this.data[rowIndex];
    }

    @Override
    public Number[] getColumn(int colIndex) throws DataSourceException {
        this.checkColumnIndex(colIndex);
        Number[] column = new Number[this.getRowCount()];
        for (int i = 0; i < this.getRowCount(); ++i) {
            column[i] = this.data[i][colIndex];
        }
        return column;
    }

    @Override
    public Number[][] getAllCells() throws DataSourceException {
        return this.data;
    }

    @Override
    public boolean hasHeaderRow() throws DataSourceException {
        return this.headerRow != null;
    }

    @Override
    public boolean hasHeaderColumn() throws DataSourceException {
        return this.headerColumn != null;
    }

    @Override
    public String getHeaderRowValue(int columnIndex) throws DataSourceException {
        this.checkHeaderRow();
        this.checkColumnIndex(columnIndex);
        return this.headerRow[columnIndex];
    }

    @Override
    public String[] getHeaderRow() throws DataSourceException {
        this.checkHeaderRow();
        return this.headerRow;
    }

    @Override
    public String getHeaderColumnValue(int rowIndex) throws DataSourceException {
        this.checkHeaderColumn();
        this.checkRowIndex(rowIndex);
        return this.headerColumn[rowIndex];
    }

    @Override
    public String[] getHeaderColumn() throws DataSourceException {
        this.checkHeaderColumn();
        return this.headerColumn;
    }

    private void checkRowIndex(int rowIndex) throws RowIndexOutOfBoundsException {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            throw new RowIndexOutOfBoundsException("Invalid row index: " + rowIndex);
        }
    }

    private void checkColumnIndex(int columnIndex) throws ColumnIndexOutOfBoundsException {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new ColumnIndexOutOfBoundsException("Invalid column index: " + columnIndex);
        }
    }

    private void checkHeaderRow() throws DataSourceException {
        if (!this.hasHeaderRow()) {
            throw new NoHeaderRowException();
        }
    }

    private void checkHeaderColumn() throws DataSourceException {
        if (!this.hasHeaderColumn()) {
            throw new NoHeaderColumnException();
        }
    }
}

