/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts;

import com.xpn.xwiki.plugin.charts.params.ChartParams;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;

public class ChartCustomizer {
    public static void customizeRenderer(AbstractRenderer renderer, ChartParams params) {
        int i;
        List list;
        if (params.get("renderer_color") != null) {
            renderer.setPaint((Paint)params.getColor("renderer_color"));
        }
        if (params.get("renderer_stroke") != null) {
            renderer.setStroke(params.getStroke("renderer_stroke"));
        }
        if (params.get("renderer_shape") != null) {
            renderer.setShape(params.getShape("renderer_shape"));
        }
        if (params.get("renderer_fill_color") != null) {
            renderer.setFillPaint((Paint)params.getColor("renderer_fill_color"));
        }
        if (params.get("renderer_outline_color") != null) {
            renderer.setOutlinePaint((Paint)params.getColor("renderer_outline_color"));
        }
        if (params.get("renderer_outline_stroke") != null) {
            renderer.setOutlineStroke(params.getStroke("renderer_outline_stroke"));
        }
        if (params.get("renderer_item_label_visible") != null) {
            if (params.getBoolean("renderer_item_label_visible").booleanValue()) {
                renderer.setItemLabelsVisible(true);
                if (params.get("renderer_item_label_color") != null) {
                    renderer.setItemLabelPaint((Paint)params.getColor("renderer_item_label_color"));
                }
                if (params.get("renderer_item_label_font") != null) {
                    renderer.setItemLabelFont(params.getFont("renderer_item_label_font"));
                }
            } else {
                renderer.setItemLabelsVisible(false);
            }
        }
        if (params.get("series_visible") != null) {
            renderer.setSeriesVisible(params.getBoolean("series_visible"));
        }
        if (params.get("series_visible_in_legend") != null) {
            renderer.setSeriesVisibleInLegend(params.getBoolean("series_visible_in_legend"));
        }
        if (params.get("series_colors") != null) {
            list = params.getList("series_colors");
            for (i = 0; i < list.size(); ++i) {
                renderer.setSeriesPaint(i, (Paint)((Color)list.get(i)));
            }
        }
        if (params.get("series_strokes") != null) {
            list = params.getList("series_strokes");
            for (i = 0; i < list.size(); ++i) {
                renderer.setSeriesStroke(i, (Stroke)list.get(i));
            }
        }
        if (params.get("series_shapes") != null) {
            list = params.getList("series_shapes");
            for (i = 0; i < list.size(); ++i) {
                renderer.setSeriesShape(i, (Shape)list.get(i));
            }
        }
        if (params.get("series_fill_colors") != null) {
            list = params.getList("series_fill_colors");
            for (i = 0; i < list.size(); ++i) {
                renderer.setSeriesFillPaint(i, (Paint)((Color)list.get(i)));
            }
        }
        if (params.get("series_outline_colors") != null) {
            list = params.getList("series_outline_colors");
            for (i = 0; i < list.size(); ++i) {
                renderer.setSeriesOutlinePaint(i, (Paint)((Color)list.get(i)));
            }
        }
        if (params.get("series_outline_strokes") != null) {
            list = params.getList("series_outline_strokes");
            for (i = 0; i < list.size(); ++i) {
                renderer.setSeriesOutlineStroke(i, (Stroke)list.get(i));
            }
        }
        if (params.get("series_item_label_visibles") != null) {
            list = params.getList("series_item_label_visibles");
            for (i = 0; i < list.size(); ++i) {
                renderer.setSeriesItemLabelsVisible(i, (Boolean)list.get(i));
            }
        }
        if (params.get("series_item_label_colors") != null) {
            list = params.getList("series_item_label_colors");
            for (i = 0; i < list.size(); ++i) {
                renderer.setSeriesItemLabelPaint(i, (Paint)((Color)list.get(i)));
            }
        }
        if (params.get("series_item_label_fonts") != null) {
            list = params.getList("series_item_label_fonts");
            for (i = 0; i < list.size(); ++i) {
                renderer.setSeriesItemLabelFont(i, (Font)list.get(i));
            }
        }
    }

    public static void customizeXYItemRenderer(XYItemRenderer renderer, ChartParams params) {
        ChartCustomizer.customizeRenderer((AbstractRenderer)renderer, params);
    }

    public static void customizeCategoryItemRenderer(CategoryItemRenderer renderer, ChartParams params) {
        ChartCustomizer.customizeRenderer((AbstractRenderer)renderer, params);
    }

    public static void customizePlot(Plot plot, ChartParams params) {
        if (params.get("plot_background_color") != null) {
            plot.setBackgroundPaint((Paint)params.getColor("plot_background_color"));
        }
        if (params.get("plot_background_alpha") != null) {
            plot.setBackgroundAlpha(params.getFloat("plot_background_alpha").floatValue());
        }
        if (params.get("plot_foreground_alpha") != null) {
            plot.setForegroundAlpha(params.getFloat("plot_foreground_alpha").floatValue());
        }
        if (params.get("plot_inserts") != null) {
            plot.setInsets(params.getRectangleInsets("plot_inserts"));
        }
        if (params.get("plot_outline_color") != null) {
            plot.setOutlinePaint((Paint)params.getColor("plot_outline_color"));
        }
        if (params.get("plot_outline_stroke") != null) {
            plot.setOutlineStroke(params.getStroke("plot_outline_stroke"));
        }
    }

    public static void customizePiePlot(PiePlot plot, ChartParams params) {
        ChartCustomizer.customizePlot((Plot)plot, params);
    }

    public static void customizeXYPlot(XYPlot plot, ChartParams params) {
        ChartCustomizer.customizePlot((Plot)plot, params);
        if (params.get("plot_orientation") != null) {
            plot.setOrientation(params.getPlotOrientation("plot_orientation"));
        }
        if (params.get("domain_axis_gridline_visible") != null) {
            if (params.getBoolean("domain_axis_gridline_visible").booleanValue()) {
                plot.setDomainGridlinesVisible(true);
                if (params.get("domain_axis_gridline_color") != null) {
                    plot.setDomainGridlinePaint((Paint)params.getColor("domain_axis_gridline_color"));
                }
                if (params.get("domain_axis_gridline_stroke") != null) {
                    plot.setDomainGridlineStroke(params.getStroke("domain_axis_gridline_stroke"));
                }
            } else {
                plot.setDomainGridlinesVisible(false);
            }
        }
        if (params.get("range_axis_gridline_visible") != null) {
            if (params.getBoolean("range_axis_gridline_visible").booleanValue()) {
                plot.setRangeGridlinesVisible(true);
                if (params.get("range_axis_gridline_color") != null) {
                    plot.setRangeGridlinePaint((Paint)params.getColor("range_axis_gridline_color"));
                }
                if (params.get("range_axis_gridline_stroke") != null) {
                    plot.setRangeGridlineStroke(params.getStroke("range_axis_gridline_stroke"));
                }
            } else {
                plot.setRangeGridlinesVisible(false);
            }
        }
        if (params.get("plot_quadrant_origin") != null) {
            plot.setQuadrantOrigin(params.getPoint2D("plot_quadrant_origin"));
        }
        if (params.get("plot_quadrant_colors") != null) {
            List colors = params.getList("plot_quadrant_colors");
            for (int i = 0; i < 4 && i < colors.size(); ++i) {
                if (colors.get(i) == null) continue;
                plot.setQuadrantPaint(i, (Paint)((Color)colors.get(i)));
            }
        }
    }

    public static void customizeAxis(Axis axis, ChartParams params, String prefix) {
        if (params.get(prefix + "visible") != null && !params.getBoolean(prefix + "visible").booleanValue()) {
            axis.setVisible(false);
        } else {
            if (params.get(prefix + "line_visible") != null) {
                if (params.getBoolean(prefix + "line_visible").booleanValue()) {
                    axis.setAxisLineVisible(true);
                    if (params.get(prefix + "line_color") != null) {
                        axis.setAxisLinePaint((Paint)params.getColor(prefix + "line_color"));
                    }
                    if (params.get(prefix + "line_stroke") != null) {
                        axis.setAxisLineStroke(params.getStroke(prefix + "line_stroke"));
                    }
                } else {
                    axis.setAxisLineVisible(false);
                }
            }
            if (params.get(prefix + "label") != null) {
                axis.setLabel(params.getString(prefix + "label"));
                if (params.get(prefix + "label_font") != null) {
                    axis.setLabelFont(params.getFont(prefix + "label_font"));
                }
                if (params.get(prefix + "label_color") != null) {
                    axis.setLabelPaint((Paint)params.getColor(prefix + "label_color"));
                }
                if (params.get(prefix + "label_inserts") != null) {
                    axis.setLabelInsets(params.getRectangleInsets(prefix + "label_inserts"));
                }
            }
            if (params.get(prefix + "tick_label_visible") != null) {
                if (params.getBoolean(prefix + "tick_label_visible").booleanValue()) {
                    axis.setTickLabelsVisible(true);
                    if (params.get(prefix + "tick_label_font") != null) {
                        axis.setTickLabelFont(params.getFont(prefix + "tick_label_font"));
                    }
                    if (params.get(prefix + "tick_label_color") != null) {
                        axis.setTickLabelPaint((Paint)params.getColor(prefix + "tick_label_color"));
                    }
                    if (params.get(prefix + "tick_label_inserts") != null) {
                        axis.setTickLabelInsets(params.getRectangleInsets(prefix + "tick_label_inserts"));
                    }
                } else {
                    axis.setTickLabelsVisible(false);
                }
            }
            if (params.get(prefix + "tick_mark_visible") != null) {
                if (params.getBoolean(prefix + "tick_mark_visible").booleanValue()) {
                    axis.setTickMarksVisible(true);
                    if (params.get(prefix + "tick_mark_inside_length") != null) {
                        axis.setTickMarkInsideLength(params.getFloat(prefix + "tick_mark_inside_length").floatValue());
                    }
                    if (params.get(prefix + "tick_mark_outside_length") != null) {
                        axis.setTickMarkOutsideLength(params.getFloat(prefix + "tick_mark_outside_length").floatValue());
                    }
                    if (params.get(prefix + "tick_mark_color") != null) {
                        axis.setTickMarkPaint((Paint)params.getColor(prefix + "tick_mark_color"));
                    }
                    if (params.get(prefix + "tick_mark_color") != null) {
                        axis.setTickMarkStroke(params.getStroke(prefix + "tick_mark_stroke"));
                    }
                } else {
                    axis.setTickMarksVisible(false);
                }
            }
        }
    }

    public static void customizeValueAxis(ValueAxis axis, ChartParams params, String prefix) {
        ChartCustomizer.customizeAxis((Axis)axis, params, prefix);
        if (params.get(prefix + "auto_range") != null) {
            axis.setAutoRange(params.getBoolean(prefix + "auto_range").booleanValue());
        }
        if (axis.isAutoRange()) {
            if (params.get(prefix + "auto_range_min_size") != null) {
                axis.setAutoRangeMinimumSize(params.getDouble(prefix + "auto_range_min_size").doubleValue());
            }
            if (params.get(prefix + "lower_margin") != null) {
                axis.setLowerMargin(params.getDouble(prefix + "lower_margin").doubleValue());
            }
            if (params.get(prefix + "upper_margin") != null) {
                axis.setUpperMargin(params.getDouble(prefix + "upper_margin").doubleValue());
            }
        } else {
            if (params.get(prefix + "lower_bound") != null) {
                axis.setLowerBound(params.getDouble(prefix + "lower_bound").doubleValue());
            }
            if (params.get(prefix + "upper_bound") != null) {
                axis.setUpperBound(params.getDouble(prefix + "upper_bound").doubleValue());
            }
        }
        if (params.get(prefix + "auto_tick_unit") != null) {
            axis.setAutoTickUnitSelection(params.getBoolean(prefix + "auto_tick_unit").booleanValue());
        }
        if (params.get(prefix + "vertical_tick_labels") != null) {
            axis.setVerticalTickLabels(params.getBoolean(prefix + "vertical_tick_labels").booleanValue());
        }
    }

    public static void customizeNumberAxis(NumberAxis axis, ChartParams params, String prefix) {
        ChartCustomizer.customizeValueAxis((ValueAxis)axis, params, prefix);
        if (axis.isAutoRange()) {
            if (params.get(prefix + "auto_range_includes_zero") != null) {
                axis.setAutoRangeIncludesZero(params.getBoolean(prefix + "auto_range_includes_zero").booleanValue());
            }
            if (params.get(prefix + "auto_range_sticky_zero") != null) {
                axis.setAutoRangeStickyZero(params.getBoolean(prefix + "auto_range_sticky_zero").booleanValue());
            }
        }
        if (params.get(prefix + "range_type") != null) {
            axis.setRangeType(params.getRangeType(prefix + "range_type"));
        }
        if (params.get(prefix + "number_tick_unit") != null) {
            if (axis.isAutoTickUnitSelection()) {
                axis.setAutoTickUnitSelection(false);
            }
            axis.setTickUnit(params.getNumberTickUnit(prefix + "number_tick_unit"));
        }
        if (params.get(prefix + "number_format") != null) {
            axis.setNumberFormatOverride(params.getNumberFormat(prefix + "number_format"));
        }
    }

    public static void customizeDateAxis(DateAxis axis, ChartParams params, String prefix) {
        ChartCustomizer.customizeValueAxis((ValueAxis)axis, params, prefix);
        if (params.get(prefix + "date_format_override") != null) {
            axis.setDateFormatOverride(params.getDateFormat(prefix + "date_format_override"));
        }
        if (params.get(prefix + "upper_date") != null) {
            axis.setMaximumDate(params.getDate(prefix + "upper_date"));
        }
        if (params.get(prefix + "lower_date") != null) {
            axis.setMinimumDate(params.getDate(prefix + "lower_date"));
        }
        if (params.get(prefix + "tick_mark_position") != null) {
            axis.setTickMarkPosition(params.getDateTickMarkPosition(prefix + "tick_mark_position"));
        }
        if (params.get(prefix + "date_tick_unit") != null) {
            if (axis.isAutoTickUnitSelection()) {
                axis.setAutoTickUnitSelection(false);
            }
            axis.setTickUnit(params.getDateTickUnit(prefix + "date_tick_unit"));
        }
    }

    public static void customizeCategoryAxis(CategoryAxis axis, ChartParams params, String prefix) {
        ChartCustomizer.customizeAxis((Axis)axis, params, prefix);
        if (params.get(prefix + "category_margin") != null) {
            axis.setCategoryMargin(params.getDouble(prefix + "category_margin").doubleValue());
        }
        if (params.get(prefix + "label_positions") != null) {
            axis.setCategoryLabelPositions(params.getCategoryLabelPositions(prefix + "label_positions"));
        }
        if (params.get(prefix + "label_position_offset") != null) {
            axis.setCategoryLabelPositionOffset(params.getInteger(prefix + "label_position_offset").intValue());
        }
        if (params.get(prefix + "maximum_label_lines") != null) {
            axis.setMaximumCategoryLabelLines(params.getInteger(prefix + "maximum_label_lines").intValue());
        }
        if (params.get(prefix + "maximul_label_width_ratio") != null) {
            axis.setMaximumCategoryLabelWidthRatio(params.getFloat(prefix + "maximul_label_width_ratio").floatValue());
        }
    }

    public static void customizeChart(JFreeChart jfchart, ChartParams params) {
        if (params.get("title") != null) {
            TextTitle title = new TextTitle(params.getString("title"));
            ChartCustomizer.customizeTitle(title, params, "title");
            jfchart.setTitle(title);
        }
        if (params.get("subtitle") != null) {
            TextTitle subtitle = new TextTitle(params.getString("subtitle"));
            ChartCustomizer.customizeTitle(subtitle, params, "subtitle");
            jfchart.addSubtitle((Title)subtitle);
        }
        LegendTitle legend = jfchart.getLegend();
        ChartCustomizer.customizeLegend(legend, params);
        if (params.get("anti_alias") != null) {
            jfchart.setAntiAlias(params.getBoolean("anti_alias").booleanValue());
        }
        if (params.get("background_color") != null) {
            jfchart.setBackgroundPaint((Paint)params.getColor("background_color"));
        }
        if (params.get("border_visible") != null && params.getBoolean("border_visible").booleanValue()) {
            jfchart.setBorderVisible(true);
            if (params.get("border_color") != null) {
                jfchart.setBorderPaint((Paint)params.getColor("border_color"));
            }
            if (params.get("border_stroke") != null) {
                jfchart.setBorderStroke(params.getStroke("border_stroke"));
            }
        }
    }

    public static void customizeTitle(TextTitle title, ChartParams params, String prefix) {
        if (params.get(prefix + "_font") != null) {
            title.setFont(params.getFont(prefix + "_font"));
        } else {
            title.setFont(JFreeChart.DEFAULT_TITLE_FONT);
        }
        if (params.get(prefix + "_position") != null) {
            title.setPosition(params.getRectangleEdge(prefix + "_position"));
        }
        if (params.get(prefix + "_horizontal_alignment") != null) {
            title.setHorizontalAlignment(params.getHorizontalAlignment(prefix + "_horizontal_alignment"));
        }
        if (params.get(prefix + "_vertical_alignment") != null) {
            title.setVerticalAlignment(params.getVerticalAlignment(prefix + "_vertical_alignment"));
        }
        if (params.get(prefix + "_color") != null) {
            title.setPaint((Paint)params.getColor(prefix + "_color"));
        }
        if (params.get(prefix + "_background_color") != null) {
            title.setBackgroundPaint((Paint)params.getColor(prefix + "_background_color"));
        }
        if (params.get(prefix + "_padding") != null) {
            title.setPadding(params.getRectangleInsets(prefix + "_padding"));
        }
        if (params.get(prefix + "_url") != null) {
            title.setURLText(params.getString(prefix + "_url"));
        }
    }

    public static void customizeLegend(LegendTitle legend, ChartParams params) {
        if (params.get("legend_background_color") != null) {
            legend.setBackgroundPaint((Paint)params.getColor("legend_background_color"));
        }
        if (params.get("legend_item_font") != null) {
            legend.setItemFont(params.getFont("legend_item_font"));
        }
        if (params.get("legend_item_label_padding") != null) {
            legend.setItemLabelPadding(params.getRectangleInsets("legend_item_label_padding"));
        }
        if (params.get("legend_item_graphic_anchor") != null) {
            legend.setLegendItemGraphicAnchor(params.getRectangleAnchor("legend_item_graphic_anchor"));
        }
        if (params.get("legend_item_graphic_edge") != null) {
            legend.setLegendItemGraphicEdge(params.getRectangleEdge("legend_item_graphic_edge"));
        }
        if (params.get("legend_item_graphic_location") != null) {
            legend.setLegendItemGraphicAnchor(params.getRectangleAnchor("legend_item_graphic_location"));
        }
        if (params.get("legend_item_graphic_padding") != null) {
            legend.setLegendItemGraphicPadding(params.getRectangleInsets("legend_item_graphic_padding"));
        }
    }
}

