/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.params;

import com.xpn.xwiki.plugin.charts.exceptions.InvalidParamException;
import com.xpn.xwiki.plugin.charts.exceptions.ParamException;
import com.xpn.xwiki.plugin.charts.params.DateFormatChartParam;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class DateChartParam
extends DateFormatChartParam {
    public DateChartParam(String name) {
        super(name);
    }

    public DateChartParam(String name, boolean optional) {
        super(name, optional);
    }

    @Override
    public Class getType() {
        return Date.class;
    }

    @Override
    public Object convert(String value) throws ParamException {
        DateFormat format;
        Map map = this.parseMap(value);
        try {
            format = (DateFormat)super.convert(value);
        }
        catch (ParamException e) {
            format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
        try {
            return format.parse(this.getStringArg(map, "value"));
        }
        catch (ParseException e) {
            throw new InvalidParamException("Invalid value for parameter :" + this.getName(), e);
        }
    }
}

