/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.params;

import com.xpn.xwiki.plugin.charts.exceptions.MissingArgumentException;
import com.xpn.xwiki.plugin.charts.exceptions.ParamException;
import com.xpn.xwiki.plugin.charts.params.AbstractChartParam;
import java.util.Locale;
import java.util.Map;

public class LocaleChartParam
extends AbstractChartParam {
    public static final String LANGUAGE = "language";
    public static final String COUNTRY = "country";
    public static final String VARIANT = "variant";

    public LocaleChartParam(String name) {
        super(name);
    }

    public LocaleChartParam(String name, boolean optional) {
        super(name, optional);
    }

    @Override
    public Class getType() {
        return Locale.class;
    }

    @Override
    public Object convert(String value) throws ParamException {
        Map map = this.parseMap(value);
        String language = this.getStringArg(map, LANGUAGE);
        try {
            String country = this.getStringArg(map, COUNTRY);
            try {
                String variant = this.getStringArg(map, VARIANT);
                return new Locale(language, country, variant);
            }
            catch (MissingArgumentException e) {
                return new Locale(language, country);
            }
        }
        catch (MissingArgumentException e) {
            return new Locale(language);
        }
    }
}

