/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.params;

import com.xpn.xwiki.plugin.charts.exceptions.InvalidArgumentException;
import com.xpn.xwiki.plugin.charts.exceptions.MissingArgumentException;
import com.xpn.xwiki.plugin.charts.exceptions.ParamException;
import com.xpn.xwiki.plugin.charts.params.LocaleChartParam;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;

public class NumberFormatChartParam
extends LocaleChartParam {
    public static final String TYPE = "type";
    public static final String GENERAL = "general";
    public static final String NUMBER = "number";
    public static final String INTEGER = "integer";
    public static final String CURRENCY = "currency";
    public static final String PERCENT = "percent";

    public NumberFormatChartParam(String name) {
        super(name);
    }

    public NumberFormatChartParam(String name, boolean optional) {
        super(name, optional);
    }

    @Override
    public Class getType() {
        return NumberFormat.class;
    }

    @Override
    public Object convert(String value) throws ParamException {
        Locale locale;
        Map map = this.parseMap(value);
        String type = this.getStringArg(map, TYPE);
        try {
            locale = (Locale)super.convert(value);
        }
        catch (MissingArgumentException e) {
            locale = null;
        }
        if (type.equals(GENERAL)) {
            if (locale != null) {
                return NumberFormat.getInstance(locale);
            }
            return NumberFormat.getInstance();
        }
        if (type.equals(NUMBER)) {
            if (locale != null) {
                return NumberFormat.getNumberInstance(locale);
            }
            return NumberFormat.getNumberInstance();
        }
        if (type.equals(INTEGER)) {
            if (locale != null) {
                return NumberFormat.getIntegerInstance(locale);
            }
            return NumberFormat.getIntegerInstance();
        }
        if (type.equals(CURRENCY)) {
            if (locale != null) {
                return NumberFormat.getCurrencyInstance(locale);
            }
            return NumberFormat.getCurrencyInstance();
        }
        if (type.equals(PERCENT)) {
            if (locale != null) {
                return NumberFormat.getPercentInstance(locale);
            }
            return NumberFormat.getPercentInstance();
        }
        throw new InvalidArgumentException("Invalid value for parameter " + this.getName() + ": Unexpected value for type argument: " + type);
    }
}

