/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.plots;

import com.xpn.xwiki.plugin.charts.ChartCustomizer;
import com.xpn.xwiki.plugin.charts.exceptions.DataSourceException;
import com.xpn.xwiki.plugin.charts.exceptions.GenerateException;
import com.xpn.xwiki.plugin.charts.params.ChartParams;
import com.xpn.xwiki.plugin.charts.source.DataSource;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class CategoryPlotFactory {
    private static CategoryPlotFactory uniqueInstance = new CategoryPlotFactory();

    private CategoryPlotFactory() {
    }

    public static CategoryPlotFactory getInstance() {
        return uniqueInstance;
    }

    public Plot create(DataSource dataSource, CategoryItemRenderer renderer, ChartParams params) throws GenerateException, DataSourceException {
        String dataSeries = params.getString("series");
        CategoryAxis domainAxis = new CategoryAxis();
        NumberAxis rangeAxis = new NumberAxis();
        ChartCustomizer.customizeCategoryAxis(domainAxis, params, "domain_axis_");
        ChartCustomizer.customizeValueAxis((ValueAxis)rangeAxis, params, "range_axis_");
        Class rendererClass = params.getClass("renderer");
        ChartCustomizer.customizeCategoryItemRenderer(renderer, params);
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        if ("columns".equals(dataSeries)) {
            for (int row = 0; row < dataSource.getRowCount(); ++row) {
                for (int column = 0; column < dataSource.getColumnCount(); ++column) {
                    dataset.addValue(dataSource.getCell(row, column), (Comparable)((Object)(dataSource.hasHeaderRow() ? dataSource.getHeaderRowValue(column) : "Category " + (column + 1))), (Comparable)((Object)(dataSource.hasHeaderColumn() ? dataSource.getHeaderColumnValue(row) : "Series " + (row + 1))));
                }
            }
        } else if ("rows".equals(dataSeries)) {
            for (int row = 0; row < dataSource.getRowCount(); ++row) {
                for (int column = 0; column < dataSource.getColumnCount(); ++column) {
                    dataset.addValue(dataSource.getCell(row, column), (Comparable)((Object)(dataSource.hasHeaderColumn() ? dataSource.getHeaderColumnValue(row) : "Category " + (row + 1))), (Comparable)((Object)(dataSource.hasHeaderRow() ? dataSource.getHeaderRowValue(column) : "Series " + (column + 1))));
                }
            }
        } else {
            throw new GenerateException("Invalid series parameter: " + dataSeries);
        }
        return new CategoryPlot((CategoryDataset)dataset, domainAxis, (ValueAxis)rangeAxis, renderer);
    }
}

