/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.plots;

import com.xpn.xwiki.plugin.charts.ChartCustomizer;
import com.xpn.xwiki.plugin.charts.exceptions.DataSourceException;
import com.xpn.xwiki.plugin.charts.exceptions.GenerateException;
import com.xpn.xwiki.plugin.charts.params.ChartParams;
import com.xpn.xwiki.plugin.charts.plots.PlotFactory;
import com.xpn.xwiki.plugin.charts.plots.TimeSeriesCollectionFactory;
import com.xpn.xwiki.plugin.charts.source.DataSource;
import java.lang.reflect.Constructor;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;

public class TimePlotFactory
implements PlotFactory {
    private static TimePlotFactory uniqueInstance = new TimePlotFactory();

    private TimePlotFactory() {
    }

    public static TimePlotFactory getInstance() {
        return uniqueInstance;
    }

    @Override
    public Plot create(DataSource dataSource, ChartParams params) throws GenerateException, DataSourceException {
        XYLineAndShapeRenderer renderer;
        Class rendererClass = params.getClass("renderer");
        if (rendererClass != null) {
            try {
                Constructor ctor = rendererClass.getConstructor(new Class[0]);
                renderer = (XYItemRenderer)ctor.newInstance(new Object[0]);
            }
            catch (Throwable e) {
                throw new GenerateException(e);
            }
        } else {
            renderer = new XYLineAndShapeRenderer();
        }
        ChartCustomizer.customizeXYItemRenderer((XYItemRenderer)renderer, params);
        DateAxis domainAxis = new DateAxis();
        ChartCustomizer.customizeDateAxis(domainAxis, params, "domain_axis_");
        NumberAxis rangeAxis = new NumberAxis();
        rangeAxis.setAutoRangeIncludesZero(false);
        ChartCustomizer.customizeNumberAxis(rangeAxis, params, "range_axis_");
        XYDataset dataset = TimeSeriesCollectionFactory.getInstance().create(dataSource, params);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
        ChartCustomizer.customizeXYPlot(plot, params);
        return plot;
    }
}

