/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.plots;

import com.xpn.xwiki.plugin.charts.ChartCustomizer;
import com.xpn.xwiki.plugin.charts.exceptions.DataSourceException;
import com.xpn.xwiki.plugin.charts.exceptions.GenerateException;
import com.xpn.xwiki.plugin.charts.params.ChartParams;
import com.xpn.xwiki.plugin.charts.plots.TableXYDatasetFactory;
import com.xpn.xwiki.plugin.charts.source.DataSource;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public class XYPlotFactory {
    private static XYPlotFactory uniqueInstance = new XYPlotFactory();

    private XYPlotFactory() {
    }

    public static XYPlotFactory getInstance() {
        return uniqueInstance;
    }

    public Plot create(DataSource dataSource, XYItemRenderer renderer, ChartParams params) throws GenerateException, DataSourceException {
        NumberAxis domainAxis = new NumberAxis();
        NumberAxis rangeAxis = new NumberAxis();
        ChartCustomizer.customizeNumberAxis(domainAxis, params, "domain_axis_");
        ChartCustomizer.customizeNumberAxis(rangeAxis, params, "range_axis_");
        XYDataset dataset = TableXYDatasetFactory.getInstance().create(dataSource, params);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, renderer);
        ChartCustomizer.customizeXYPlot(plot, params);
        return plot;
    }
}

