/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.source;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.charts.RadeoxHelper;
import com.xpn.xwiki.plugin.charts.exceptions.DataSourceException;
import com.xpn.xwiki.plugin.charts.exceptions.EmptyDataSourceException;
import com.xpn.xwiki.plugin.charts.source.DataSource;
import com.xpn.xwiki.plugin.charts.source.DefaultDataSource;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.radeox.macro.table.Table;

public class TableDataSource
extends DefaultDataSource
implements DataSource {
    public static final String DOC = "doc";
    public static final String TABLE_NUMBER = "table_number";
    public static final String RANGE = "range";
    public static final String HAS_HEADER_ROW = "has_header_row";
    public static final String HAS_HEADER_COLUMN = "has_header_column";
    public static final String DECIMAL_SYMBOL = "decimal_symbol";
    public static final String IGNORE_ALPHA = "ignore_alpha";
    public static final String COMMA_SELECTOR = "comma";
    public static final String PERIOD_SELECTOR = "period";
    public static final int DEFAULT_TABLE_NUMBER = 0;
    public static final String DEFAULT_RANGE = "*";
    public static final boolean DEFAULT_HAS_HEADER_ROW = true;
    public static final boolean DEFAULT_HAS_HEADER_COLUMN = true;
    public static final String DEFAULT_DECIMAL_SYMBOL = "period";
    public static final boolean DEFAULT_IGNORE_ALPHA = false;
    public static final char COMMA = ',';
    public static final char PERIOD = '.';
    public static final char RANGE_SEP = '-';
    private int startColumn = -1;
    private int endColumn = -1;
    private int startRow = -1;
    private int endRow = -1;
    private int headerColumnIndex = -1;
    private int headerRowIndex = -1;
    private char decimalSymbol = (char)46;
    private char digitGroupingSymbol = (char)44;
    private boolean ignoreAlpha = false;

    public TableDataSource(BaseObject defObject, XWikiContext context) throws DataSourceException {
        this.init(defObject.getName(), defObject.getIntValue(TABLE_NUMBER), defObject.getStringValue(RANGE) == "" ? DEFAULT_RANGE : defObject.getStringValue(RANGE), defObject.getIntValue(HAS_HEADER_ROW) == 1, defObject.getIntValue(HAS_HEADER_COLUMN) == 1, defObject.getStringValue(DECIMAL_SYMBOL) == "" ? "period" : defObject.getStringValue(DECIMAL_SYMBOL), defObject.getIntValue(IGNORE_ALPHA) == 1, context);
    }

    public TableDataSource(Map params, XWikiContext context) throws DataSourceException {
        String hhr;
        int number;
        String n;
        String doc = (String)params.get(DOC);
        if (doc == null) {
            doc = context.getDoc().getFullName();
        }
        if ((n = (String)params.get(TABLE_NUMBER)) != null) {
            try {
                number = Integer.parseInt(n);
            }
            catch (NumberFormatException e) {
                throw new DataSourceException("Invalid argument table_number for parameter source: integer value expected");
            }
        } else {
            number = 0;
        }
        String range = (String)params.get(RANGE);
        if (range == null) {
            range = DEFAULT_RANGE;
        }
        boolean hasHeaderRow = (hhr = (String)params.get(HAS_HEADER_ROW)) != null ? hhr.equalsIgnoreCase("true") : true;
        String hhc = (String)params.get(HAS_HEADER_COLUMN);
        boolean hasHeaderColumn = hhc != null ? hhc.equalsIgnoreCase("true") : true;
        String decimal = (String)params.get(DECIMAL_SYMBOL);
        String ia = (String)params.get(IGNORE_ALPHA);
        boolean ignoreAlpha = ia != null ? ia.equals("true") : false;
        this.init(doc, number, range, hasHeaderRow, hasHeaderColumn, decimal, ignoreAlpha, context);
    }

    private void init(String docName, int tableNumber, String range, boolean hasHeaderRow, boolean hasHeaderColumn, String decimalSymbolSelector, boolean ignoreAlpha, XWikiContext context) throws DataSourceException {
        try {
            XWikiDocument doc = context.getWiki().getDocument(docName, context);
            RadeoxHelper rHelper = new RadeoxHelper(doc, context);
            Table table = rHelper.getTable(tableNumber);
            this.parseRange(range, hasHeaderRow, hasHeaderColumn, table);
            this.setDecimalSymbol(decimalSymbolSelector);
            this.ignoreAlpha = ignoreAlpha;
            this.makeDataMatrix(table);
            this.makeHeaders(table);
        }
        catch (NumberFormatException e) {
            throw new DataSourceException(e);
        }
        catch (XWikiException e) {
            throw new DataSourceException(e);
        }
    }

    private void setDecimalSymbol(String decimalSymbolSelector) throws DataSourceException {
        if (decimalSymbolSelector != null) {
            if (decimalSymbolSelector.equals(COMMA_SELECTOR)) {
                this.decimalSymbol = (char)44;
                this.digitGroupingSymbol = (char)46;
            } else if (decimalSymbolSelector.equals("period")) {
                this.decimalSymbol = (char)46;
                this.digitGroupingSymbol = (char)44;
            } else {
                throw new DataSourceException("Invalid argument decimal_symbol for parameter source:comma or period expected; found: " + decimalSymbolSelector);
            }
        }
    }

    private void makeDataMatrix(Table t) {
        this.data = new Number[this.endRow - this.startRow + 1][this.endColumn - this.startColumn + 1];
        for (int y = this.startRow; y <= this.endRow; ++y) {
            for (int x = this.startColumn; x <= this.endColumn; ++x) {
                try {
                    this.data[y - this.startRow][x - this.startColumn] = this.toNumber(t.getXY(x, y).toString());
                    continue;
                }
                catch (Exception e) {
                    this.data[y - this.startRow][x - this.startColumn] = null;
                }
            }
        }
    }

    private void makeHeaders(Table t) {
        if (this.headerColumnIndex >= 0) {
            this.headerColumn = new String[this.endRow - this.startRow + 1];
            for (int y = this.startRow; y <= this.endRow; ++y) {
                try {
                    this.headerColumn[y - this.startRow] = t.getXY(this.headerColumnIndex, y).toString();
                    continue;
                }
                catch (Exception e) {
                    this.headerColumn[y - this.startRow] = "";
                }
            }
        }
        if (this.headerRowIndex >= 0) {
            this.headerRow = new String[this.endColumn - this.startColumn + 1];
            for (int x = this.startColumn; x <= this.endColumn; ++x) {
                try {
                    this.headerRow[x - this.startColumn] = t.getXY(x, this.headerRowIndex).toString();
                    continue;
                }
                catch (Exception ex) {
                    this.headerRow[x - this.startColumn] = "";
                }
            }
        }
    }

    private Number toNumber(String str) throws NumberFormatException {
        str = str.trim();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if ('0' <= ch && ch <= '9') {
                sb.append(ch);
                continue;
            }
            if (ch == this.decimalSymbol) {
                sb.append(".");
                continue;
            }
            if (ch == this.digitGroupingSymbol) {
                if (sb.length() > 0 && i < str.length() - 1 && '0' <= str.charAt(i - 1) && str.charAt(i - 1) <= '9' && '0' <= str.charAt(i + 1) && str.charAt(i + 1) <= '9' || this.ignoreAlpha) continue;
                throw new NumberFormatException("Invalid character: " + ch);
            }
            if (this.ignoreAlpha) continue;
            throw new NumberFormatException("Invalid character: " + ch);
        }
        str = sb.toString();
        try {
            return new Long(str);
        }
        catch (NumberFormatException e1) {
            try {
                return new Double(str);
            }
            catch (NumberFormatException e2) {
                try {
                    new BigInteger(str);
                }
                catch (NumberFormatException e3) {
                    try {
                        return new BigDecimal(str);
                    }
                    catch (NumberFormatException e4) {
                        return null;
                    }
                }
                return null;
            }
        }
    }

    private void parseRange(String range, boolean hasHeaderRow, boolean hasHeaderColumn, Table t) throws DataSourceException {
        if (range.matches("[A-Z][0-9]+-[A-Z][0-9]+")) {
            this.startColumn = range.charAt(0) - 65;
            this.startRow = Integer.parseInt(range.substring(1, range.indexOf(45))) - 1;
            this.endColumn = range.charAt(range.indexOf(45) + 1) - 65;
            this.endRow = Integer.parseInt(range.substring(range.indexOf(45) + 2)) - 1;
        } else if (range.matches("[A-Z]-[A-Z]")) {
            this.startColumn = range.charAt(0) - 65;
            this.startRow = 0;
            this.endColumn = range.charAt(range.indexOf(45) + 1) - 65;
            this.endRow = TableDataSource.getTableRowCount(t);
        } else if (range.matches("[0-9]+-[0-9]+")) {
            this.startColumn = 0;
            this.startRow = Integer.parseInt(range.substring(0, range.indexOf(45))) - 1;
            this.endColumn = TableDataSource.getTableColumnCount(t);
            this.endRow = Integer.parseInt(range.substring(range.indexOf(45) + 1)) - 1;
        } else if (range.equals(DEFAULT_RANGE)) {
            this.startColumn = 0;
            this.startRow = 0;
            this.endColumn = TableDataSource.getTableColumnCount(t);
            this.endRow = TableDataSource.getTableRowCount(t);
        }
        if (hasHeaderColumn) {
            this.headerColumnIndex = this.startColumn++;
            if (this.startColumn > this.endColumn) {
                throw new EmptyDataSourceException("Data source cannot contain only a header");
            }
        }
        if (hasHeaderRow) {
            this.headerRowIndex = this.startRow++;
            if (this.startRow > this.endRow) {
                throw new EmptyDataSourceException("Data source cannot contain only a header");
            }
        }
    }

    public static int getTableColumnCount(Table t) throws DataSourceException {
        int i = 0;
        try {
            while (true) {
                t.getXY(i, 0);
                ++i;
            }
        }
        catch (Exception ex) {
            if (--i < 0) {
                throw new EmptyDataSourceException();
            }
            return i;
        }
    }

    public static int getTableRowCount(Table t) throws DataSourceException {
        int i = 0;
        try {
            while (true) {
                t.getXY(0, i);
                ++i;
            }
        }
        catch (Exception ex) {
            if (--i < 0) {
                throw new EmptyDataSourceException();
            }
            return i;
        }
    }
}

