/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.source;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.plugin.charts.exceptions.DataSourceException;
import com.xpn.xwiki.plugin.charts.source.DataSource;
import com.xpn.xwiki.plugin.charts.source.DataSourceFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

public class ObjectidDataSourceFactory
implements DataSourceFactory {
    private static DataSourceFactory uniqueInstance = new ObjectidDataSourceFactory();

    private ObjectidDataSourceFactory() {
    }

    public static DataSourceFactory getInstance() {
        return uniqueInstance;
    }

    @Override
    public DataSource create(Map params, XWikiContext context) throws DataSourceException {
        BaseObject xobj;
        int objectid;
        try {
            String id = (String)params.get("id");
            if (id == null) {
                throw new DataSourceException("source=type:objectid implies the presence of an id argument");
            }
            objectid = Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            throw new DataSourceException(e);
        }
        try {
            List list = context.getWiki().getStore().search("from " + BaseObject.class.getName() + " as obj where obj.id='" + objectid + "'", 0, 0, context);
            if (list.size() == 0) {
                throw new DataSourceException("Object ID not found");
            }
            xobj = (BaseObject)list.get(0);
            List propertyList = context.getWiki().getStore().search("from " + BaseProperty.class.getName() + " as p where p.id.id='" + objectid + "'", 0, 0, context);
            for (BaseProperty prop : propertyList) {
                xobj.addField(prop.getName(), (PropertyInterface)prop);
            }
        }
        catch (XWikiException e) {
            throw new DataSourceException(e);
        }
        String xclass = xobj.getClassName();
        if (!xclass.startsWith("XWiki.")) {
            throw new DataSourceException("XWiki prefix missing in object class name " + xclass);
        }
        String className = DataSource.class.getPackage().getName() + "." + xclass.substring("XWiki.".length());
        try {
            Class<?> class_ = Class.forName(className);
            Constructor<?> ctor = class_.getConstructor(BaseObject.class, XWikiContext.class);
            return (DataSource)ctor.newInstance(xobj, context);
        }
        catch (InvocationTargetException e) {
            throw new DataSourceException(e.getTargetException());
        }
        catch (Exception e) {
            throw new DataSourceException(e);
        }
    }
}

