/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.charts.source;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.charts.exceptions.DataSourceException;
import com.xpn.xwiki.plugin.charts.source.DataSource;
import com.xpn.xwiki.plugin.charts.source.DataSourceFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class ObjectDataSourceFactory
implements DataSourceFactory {
    private static DataSourceFactory uniqueInstance = new ObjectDataSourceFactory();

    private ObjectDataSourceFactory() {
    }

    public static DataSourceFactory getInstance() {
        return uniqueInstance;
    }

    @Override
    public DataSource create(Map params, XWikiContext context) throws DataSourceException {
        int number;
        XWikiDocument doc;
        String docName = (String)params.get("doc");
        if (docName == null) {
            throw new DataSourceException("source=type:object implies the presence of a doc argument");
        }
        try {
            doc = context.getWiki().getDocument(docName, context);
        }
        catch (XWikiException e) {
            throw new DataSourceException(e);
        }
        String className = (String)params.get("class");
        if (className == null) {
            throw new DataSourceException("source=type:object implies the presence of a class argument");
        }
        try {
            String s = (String)params.get("object_number");
            try {
                number = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new DataSourceException(e);
            }
        }
        catch (NumberFormatException e) {
            throw new DataSourceException(e);
        }
        BaseObject xobj = doc.getObject("XWiki." + className, number);
        if (xobj == null) {
            throw new DataSourceException("XWiki." + className + "#" + number + " object not found");
        }
        try {
            Class<?> class_ = Class.forName(this.getClass().getPackage().getName() + "." + className);
            Constructor<?> ctor = class_.getConstructor(BaseObject.class, XWikiContext.class);
            return (DataSource)ctor.newInstance(xobj, context);
        }
        catch (InvocationTargetException e) {
            throw new DataSourceException(e.getTargetException());
        }
        catch (Exception e) {
            throw new DataSourceException(e);
        }
    }
}

