/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal;

import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jfree.chart.JFreeChart;
import org.xwiki.chart.ChartCustomizer;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="visibility")
@Singleton
public class VisibilityChartCustomizer
implements ChartCustomizer {
    private static final String PLOT_BORDER_VISIBLE = "plotBorderVisible";
    private static final String LEGEND_VISIBLE = "legendVisible";

    @Override
    public void customize(JFreeChart jfchart, Map<String, String> parameters) {
        if (parameters.get(PLOT_BORDER_VISIBLE) != null) {
            jfchart.getPlot().setOutlineVisible(Boolean.parseBoolean(parameters.get(PLOT_BORDER_VISIBLE)));
        }
        if (parameters.get(LEGEND_VISIBLE) != null && !Boolean.parseBoolean(parameters.get(LEGEND_VISIBLE))) {
            jfchart.removeLegend();
        }
    }
}

