/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal.plot;

import java.util.Map;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.xwiki.chart.internal.plot.PlotGenerator;
import org.xwiki.chart.model.ChartModel;

public abstract class AbstractXYPlotGenerator
implements PlotGenerator {
    @Override
    public Plot generate(ChartModel model, Map<String, String> parameters) {
        NumberAxis domainAxis = new NumberAxis();
        NumberAxis rangeAxis = new NumberAxis();
        XYDataset dataset = this.buildXYDataset(model, parameters);
        return new XYPlot(dataset, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, this.getXYItemRenderer(parameters));
    }

    protected XYDataset buildXYDataset(ChartModel model, Map<String, String> params) {
        String dataSeries = params.get("series");
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        if (dataSeries.equals("rows")) {
            this.extractRows(dataset, model);
        } else {
            this.extractColumns(dataset, model);
        }
        return dataset;
    }

    private void extractRows(DefaultTableXYDataset dataset, ChartModel model) {
        for (int row = 0; row < model.getRowCount(); ++row) {
            XYSeries series = new XYSeries((Comparable)((Object)model.getRowHeader(row)), false, false);
            for (int column = 0; column < model.getColumnCount(); ++column) {
                series.add((double)column, model.getCellValue(row, column));
            }
            dataset.addSeries(series);
        }
    }

    private void extractColumns(DefaultTableXYDataset dataset, ChartModel model) {
        for (int column = 0; column < model.getColumnCount(); ++column) {
            XYSeries series = new XYSeries((Comparable)((Object)model.getColumnHeader(column)), false, false);
            for (int row = 0; row < model.getRowCount(); ++row) {
                series.add((double)row, model.getCellValue(row, column));
            }
            dataset.addSeries(series);
        }
    }

    protected abstract XYItemRenderer getXYItemRenderer(Map<String, String> var1);
}

