/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.internal.AbstractEntityComponentManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="wiki")
@Singleton
public class WikiComponentManager
extends AbstractEntityComponentManager
implements Initializable {
    public static final String ID = "wiki";
    private static final String KEY_PREFIX = "wiki:";
    @Inject
    private WikiDescriptorManager wikis;
    @Inject
    private ComponentManager rootComponentManager;

    private String getCurrentWiki() {
        return this.wikis.getCurrentWikiId();
    }

    @Override
    protected EntityReference getCurrentReference() {
        String currentWikiId = this.getCurrentWiki();
        return currentWikiId != null ? new WikiReference(currentWikiId) : null;
    }

    @Override
    protected String getKey() {
        String wiki = this.getCurrentWiki();
        return wiki != null ? KEY_PREFIX + wiki : null;
    }

    public void initialize() throws InitializationException {
        this.setInternalParent(this.rootComponentManager);
    }
}

