/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.event.ComponentDescriptorAddedEvent;
import org.xwiki.component.internal.AbstractEntityComponentManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="org.xwiki.component.internal.ComponentCreatedListener")
@Singleton
public class ComponentCreatedListener
extends AbstractEventListener {
    @Inject
    @Named(value="user")
    private Provider<ComponentManager> userComponentManagerProvider;
    @Inject
    @Named(value="document")
    private Provider<ComponentManager> documentComponentManagerProvider;
    @Inject
    @Named(value="space")
    private Provider<ComponentManager> spaceComponentManagerProvider;
    @Inject
    @Named(value="wiki")
    private Provider<ComponentManager> wikiComponentManagerProvider;

    public ComponentCreatedListener() {
        super(ComponentCreatedListener.class.getName(), new Event[]{new ComponentDescriptorAddedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        this.notifyComponentManager(this.userComponentManagerProvider);
        this.notifyComponentManager(this.documentComponentManagerProvider);
        this.notifyComponentManager(this.spaceComponentManagerProvider);
        this.notifyComponentManager(this.wikiComponentManagerProvider);
    }

    private void notifyComponentManager(Provider<ComponentManager> provider) {
        ComponentManager componentManager = (ComponentManager)provider.get();
        if (componentManager instanceof AbstractEntityComponentManager) {
            ((AbstractEntityComponentManager)componentManager).onComponentAdded();
        }
    }
}

