/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.component.wiki.internal.bridge;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.MissingParserException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;

/**
 * A bridge between Wiki Components and rendering.
 *
 * @version $Id: 22307cde98baf63913546caabfa3ebd0a6faefc8 $
 * @since 4.3M2
 */
@Component
@Singleton
public class DefaultContentParser implements ContentParser
{
    /**
     * Used to retrieve parsers dynamically depending on documents syntax.
     */
    @Inject
    private org.xwiki.rendering.parser.ContentParser contentParser;

    @Override
    public XDOM parse(String content, Syntax syntax) throws WikiComponentException
    {
        return parse(content, syntax, null);
    }

    @Override
    public XDOM parse(String content, Syntax syntax, EntityReference source) throws WikiComponentException
    {
        try {
            return contentParser.parse(content, syntax, source);
        } catch (ParseException e) {
            throw new WikiComponentException(String.format("Failed to parse content [%s]", content), e);
        } catch (MissingParserException e) {
            throw new WikiComponentException(String.format("Failed to find a parser to parse syntax [%s]", syntax), e);
        }
    }
}
