/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.wiki.internal.bridge;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.WikiObjectComponentBuilder;
import org.xwiki.component.wiki.internal.WikiComponentManagerEventListenerHelper;
import org.xwiki.component.wiki.internal.bridge.WikiBaseObjectComponentBuilder;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;

@Component(roles={WikiObjectComponentManagerEventListenerProxy.class})
@Singleton
public class WikiObjectComponentManagerEventListenerProxy {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private ComponentManager contextComponent;
    @Inject
    private WikiComponentManagerEventListenerHelper wikiComponentManagerEventListenerHelper;
    @Inject
    private QueryManager queryManager;
    @Inject
    private Provider<XWikiContext> xWikiContextProvider;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;

    private List<EntityReference> collectWikiObjectsList() {
        ArrayList<EntityReference> wikiObjectsList = new ArrayList<EntityReference>();
        try {
            List componentBuilders = this.contextComponent.getInstanceList(WikiObjectComponentBuilder.class);
            for (WikiObjectComponentBuilder componentBuilder : componentBuilders) {
                wikiObjectsList.add(componentBuilder.getClassReference());
            }
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Unable to collect a list of wiki objects components: %s", (Throwable)e);
        }
        return wikiObjectsList;
    }

    public void registerAllObjectComponents() {
        XWikiContext xWikiContext = (XWikiContext)this.xWikiContextProvider.get();
        for (EntityReference xObjectClass : this.collectWikiObjectsList()) {
            try {
                Query query = this.queryManager.createQuery("select distinct doc.fullName from Document doc, doc.object(" + (String)this.entityReferenceSerializer.serialize(xObjectClass, new Object[0]) + ") as document", "xwql");
                List results = query.execute();
                for (String result : results) {
                    DocumentReference sourceDocumentReference = this.currentDocumentReferenceResolver.resolve((Object)result, new Object[0]);
                    XWikiDocument document = xWikiContext.getWiki().getDocument(sourceDocumentReference, xWikiContext);
                    for (BaseObject xObject : document.getXObjects(xObjectClass)) {
                        if (xObject == null) continue;
                        BaseObjectReference xObjectReference = (BaseObjectReference)xObject.getReference();
                        String builderHelper = (String)this.entityReferenceSerializer.serialize((EntityReference)xObjectReference.getXClassReference(), new Object[0]);
                        this.registerObjectComponents((ObjectReference)xObjectReference, xObject, (WikiObjectComponentBuilder)this.contextComponent.getInstance(WikiObjectComponentBuilder.class, builderHelper));
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn(String.format("Unable to register the components for [%s] XObjects: %s", xObjectClass, ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }
    }

    public void registerObjectComponents(ObjectReference objectReference, BaseObject baseObject, WikiObjectComponentBuilder componentBuilder) {
        this.wikiComponentManagerEventListenerHelper.unregisterComponents((EntityReference)objectReference);
        try {
            List<WikiComponent> wikiComponents = componentBuilder instanceof WikiBaseObjectComponentBuilder ? ((WikiBaseObjectComponentBuilder)componentBuilder).buildComponents(baseObject) : componentBuilder.buildComponents(objectReference);
            this.wikiComponentManagerEventListenerHelper.registerComponentList(wikiComponents);
        }
        catch (WikiComponentException e) {
            this.logger.warn(String.format("Unable to register the component associated to [%s]: %s", objectReference, ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
    }

    public void unregisterObjectComponents(ObjectReference xObjectReference) {
        this.wikiComponentManagerEventListenerHelper.unregisterComponents((EntityReference)xObjectReference);
    }

    public List<EntityReference> getWikiObjectsList() {
        return this.collectWikiObjectsList();
    }
}

