/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.internal.CompositeConfigurationSource;

public class CompositeWikiConfigurationSource
extends CompositeConfigurationSource {
    protected List<String> wikiHints = new ArrayList<String>();
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ComponentManager componentManager;
    private volatile boolean wikiInitialized;
    @Inject
    private Logger logger;

    public void addWikiConfigurationSource(String wikiHint) {
        this.wikiHints.add(wikiHint);
    }

    private synchronized List<ConfigurationSource> initializeWikiSources() {
        if (this.wikiInitialized) {
            return this.sources;
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> newSources = new ArrayList<Object>(this.sources.size() + this.wikiHints.size());
        for (String wikiHint : this.wikiHints) {
            try {
                newSources.add(this.componentManager.getInstance(ConfigurationSource.class, wikiHint));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to lookup configuration source with hint [%s]. It won't be used.", (Object)wikiHint, (Object)e);
            }
        }
        this.sources = newSources;
        return this.sources;
    }

    @Override
    public Iterator<ConfigurationSource> iterator() {
        if (!this.wikiInitialized) {
            this.initializeWikiSources();
        }
        return super.iterator();
    }
}

