/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelConfiguration;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.WikiReference;

public abstract class AbstractDocumentConfigurationSource
implements ConfigurationSource {
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ModelContext modelContext;
    @Inject
    private ModelConfiguration modelConfig;

    protected abstract DocumentReference getDocumentReference();

    protected abstract DocumentReference getClassReference();

    protected DocumentAccessBridge getDocumentAccessBridge() {
        return this.documentAccessBridge;
    }

    protected WikiReference getCurrentWikiReference() {
        if (this.modelContext.getCurrentEntityReference() != null) {
            return (WikiReference)this.modelContext.getCurrentEntityReference().extractReference(EntityType.WIKI);
        }
        return new WikiReference(this.modelConfig.getDefaultReferenceValue(EntityType.WIKI));
    }

    public boolean containsKey(String key) {
        DocumentReference documentReference = this.getFailsafeDocumentReference();
        DocumentReference classReference = this.getFailsafeClassReference();
        return documentReference != null && classReference != null && this.getDocumentAccessBridge().getProperty(documentReference, classReference, key) != null;
    }

    public List<String> getKeys() {
        return null;
    }

    public <T> T getProperty(String key, T defaultValue) {
        return this.getProperty(key, defaultValue, defaultValue.getClass());
    }

    public <T> T getProperty(String key, Class<T> valueClass) {
        T result = null;
        DocumentReference documentReference = this.getFailsafeDocumentReference();
        DocumentReference classReference = this.getFailsafeClassReference();
        if (documentReference != null && classReference != null && (result = (T)valueClass.cast(this.getDocumentAccessBridge().getProperty(documentReference, classReference, key))) == null) {
            if (List.class.isAssignableFrom(valueClass)) {
                result = valueClass.cast(Collections.emptyList());
            } else if (Properties.class.isAssignableFrom(valueClass)) {
                result = valueClass.cast(new Properties());
            }
        }
        return result;
    }

    public <T> T getProperty(String key) {
        Object result = null;
        DocumentReference documentReference = this.getFailsafeDocumentReference();
        DocumentReference classReference = this.getFailsafeClassReference();
        if (documentReference != null && classReference != null) {
            result = this.getDocumentAccessBridge().getProperty(documentReference, classReference, key);
        }
        return (T)result;
    }

    public boolean isEmpty() {
        return this.getKeys().isEmpty();
    }

    private <T> T getProperty(String key, T defaultValue, Class<T> valueClass) {
        T result = this.getProperty(key, valueClass);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    private DocumentReference getFailsafeDocumentReference() {
        DocumentReference documentReference;
        try {
            documentReference = this.getDocumentReference();
        }
        catch (Exception e) {
            documentReference = null;
        }
        return documentReference;
    }

    private DocumentReference getFailsafeClassReference() {
        DocumentReference classReference;
        try {
            classReference = this.getDocumentReference();
        }
        catch (Exception e) {
            classReference = null;
        }
        return classReference;
    }
}

