/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.internal.CommonsConfigurationSource;
import org.xwiki.container.Container;

@Component
@Named(value="xwikiproperties")
@Singleton
public class XWikiPropertiesConfigurationSource
extends CommonsConfigurationSource
implements Initializable {
    private static final String XWIKI_PROPERTIES_FILE = "/WEB-INF/xwiki.properties";
    @Inject
    private Container container;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        try {
            URL xwikiPropertiesUrl = this.container.getApplicationContext().getResource(XWIKI_PROPERTIES_FILE);
            if (xwikiPropertiesUrl != null) {
                this.setConfiguration((Configuration)new PropertiesConfiguration(xwikiPropertiesUrl));
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("No configuration file [/WEB-INF/xwiki.properties] found. Using default configuration values.");
                this.setConfiguration((Configuration)new BaseConfiguration());
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to load configuration file [/WEB-INF/xwiki.properties]. Using default configuration values.  Internal error [" + e.getMessage() + "]");
            this.setConfiguration((Configuration)new BaseConfiguration());
        }
    }
}

