/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.container.servlet.internal.ForwardedHeader;

public final class HttpServletUtils {
    public static final String HEADER_FORWARDED = "forwarded";
    public static final String HEADER_X_FORWARDED_HOST = "x-forwarded-host";
    public static final String HEADER_X_FORWARDED_PROTO = "x-forwarded-proto";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    private HttpServletUtils() {
    }

    public static URL getSourceURL(HttpServletRequest servletRequest) {
        URL baseURL = HttpServletUtils.getSourceBaseURL(servletRequest);
        StringBuilder path = new StringBuilder();
        path.append(servletRequest.getRequestURI());
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{servletRequest.getQueryString()})) {
            path.append('?');
            path.append(servletRequest.getQueryString());
        }
        try {
            return new URL(baseURL, path.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("XWiki received an invalid URL path or query string", e);
        }
    }

    public static URL getSourceBaseURL(HttpServletRequest servletRequest) {
        StringBuilder builder = new StringBuilder();
        HttpServletUtils.appendScheme(servletRequest, builder);
        builder.append("://");
        HttpServletUtils.appendHostPort(servletRequest, builder);
        try {
            return new URL(builder.toString());
        }
        catch (MalformedURLException e) {
            return HttpServletUtils.getFinalBaseURL(servletRequest);
        }
    }

    private static URL getFinalBaseURL(HttpServletRequest servletRequest) {
        try {
            return new URL(servletRequest.getScheme(), servletRequest.getRemoteHost(), servletRequest.getRemotePort(), "");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("XWiki received an invalid URL", e);
        }
    }

    private static void appendScheme(HttpServletRequest request, StringBuilder builder) {
        ForwardedHeader forwardedHeader;
        String forwarded = request.getHeader(HEADER_FORWARDED);
        if (StringUtils.isNotEmpty((CharSequence)forwarded) && (forwardedHeader = new ForwardedHeader(forwarded)).getProto() != null) {
            builder.append(forwardedHeader.getProto());
            return;
        }
        String proxyProto = HttpServletUtils.getFirstHeaderValue(request, HEADER_X_FORWARDED_PROTO);
        if (proxyProto != null) {
            builder.append(proxyProto);
            return;
        }
        String scheme = request.getScheme();
        if (HTTP.equalsIgnoreCase(scheme) && request.isSecure()) {
            scheme = HTTPS;
        }
        builder.append(scheme != null ? scheme : HTTP);
    }

    private static void appendHostPort(HttpServletRequest request, StringBuilder builder) {
        ForwardedHeader forwardedHeader;
        String forwarded = request.getHeader(HEADER_FORWARDED);
        if (StringUtils.isNotEmpty((CharSequence)forwarded) && (forwardedHeader = new ForwardedHeader(forwarded)).getHost() != null) {
            builder.append(forwardedHeader.getHost());
            return;
        }
        String proxyHost = HttpServletUtils.getFirstHeaderValue(request, HEADER_X_FORWARDED_HOST);
        if (proxyHost != null) {
            builder.append(proxyHost);
            return;
        }
        builder.append(request.getServerName());
        int port = request.getServerPort();
        if (port != -1) {
            builder.append(':');
            builder.append(port);
        }
    }

    private static String getFirstHeaderValue(HttpServletRequest request, String key) {
        String value = request.getHeader(key);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            int index = value.indexOf(44);
            if (index != -1) {
                value = value.substring(0, index);
            }
            if (StringUtils.isNotEmpty((CharSequence)(value = value.trim()))) {
                return value;
            }
        }
        return null;
    }
}

