/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet;

import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;

public class SetThreadNameServletRequestListener
implements ServletRequestListener {
    private static final String ORIGINAL_THREAD_NAME_ATTRIBUTE = "xwiki.thread.originalName";

    public void requestInitialized(ServletRequestEvent sre) {
        ServletRequest servletRequest = sre.getServletRequest();
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            String threadName = httpServletRequest.getRequestURL().toString();
            if (httpServletRequest.getQueryString() != null) {
                threadName = threadName + "?" + httpServletRequest.getQueryString();
            }
            String originalThreadName = Thread.currentThread().getName();
            threadName = String.format("%s - %s", originalThreadName, threadName);
            httpServletRequest.setAttribute(ORIGINAL_THREAD_NAME_ATTRIBUTE, (Object)originalThreadName);
            Thread.currentThread().setName(threadName);
        }
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        ServletRequest servletRequest = sre.getServletRequest();
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            Thread.currentThread().setName("" + httpServletRequest.getAttribute(ORIGINAL_THREAD_NAME_ATTRIBUTE));
        }
    }
}

