/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.container.servlet.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.container.ApplicationContext;
import org.xwiki.container.ApplicationContextListenerManager;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.RequestInitializerManager;
import org.xwiki.container.Response;
import org.xwiki.container.Session;
import org.xwiki.container.servlet.ServletApplicationContext;
import org.xwiki.container.servlet.ServletContainerException;
import org.xwiki.container.servlet.ServletContainerInitializer;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.container.servlet.ServletSession;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextManager;

@Component
@Singleton
public class DefaultServletContainerInitializer
implements ServletContainerInitializer {
    @Inject
    private ApplicationContextListenerManager applicationContextListenerManager;
    @Inject
    private Container container;
    @Inject
    private Execution execution;
    @Inject
    private ComponentManager componentManager;

    @Override
    @Deprecated
    public void initializeApplicationContext(ServletContext servletContext) {
        ServletApplicationContext applicationContext = new ServletApplicationContext(servletContext, this.componentManager);
        this.container.setApplicationContext((ApplicationContext)applicationContext);
        this.applicationContextListenerManager.initializeApplicationContext((ApplicationContext)applicationContext);
    }

    @Override
    public void initializeRequest(HttpServletRequest httpServletRequest, Object xwikiContext) throws ServletContainerException {
        RequestInitializerManager manager;
        this.container.setRequest((Request)new ServletRequest(httpServletRequest));
        this.execution.setContext(new ExecutionContext());
        if (xwikiContext != null) {
            String key;
            ExecutionContext ec = this.execution.getContext();
            if (ec.hasProperty(key = "xwikicontext")) {
                ec.setProperty(key, xwikiContext);
            } else {
                ec.newProperty(key).inherited().initial(xwikiContext).declare();
            }
        }
        try {
            manager = (RequestInitializerManager)this.componentManager.getInstance(RequestInitializerManager.class);
            manager.initializeRequest(this.container.getRequest());
        }
        catch (Exception e) {
            throw new ServletContainerException("Failed to initialize request", e);
        }
        try {
            manager = (ExecutionContextManager)this.componentManager.getInstance(ExecutionContextManager.class);
            manager.initialize(this.execution.getContext());
        }
        catch (Exception e) {
            throw new ServletContainerException("Failed to initialize Execution Context", e);
        }
    }

    @Override
    public void initializeRequest(HttpServletRequest httpServletRequest) throws ServletContainerException {
        this.initializeRequest(httpServletRequest, null);
    }

    @Override
    public void initializeResponse(HttpServletResponse httpServletResponse) {
        this.container.setResponse((Response)new ServletResponse(httpServletResponse));
    }

    @Override
    public void initializeSession(HttpServletRequest httpServletRequest) {
        this.container.setSession((Session)new ServletSession(httpServletRequest));
    }
}

