/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.cipher.internal.symmetric.factory;

import javax.inject.Named;
import javax.inject.Singleton;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RC564Engine;
import org.bouncycastle.crypto.params.RC5Parameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.cipher.internal.symmetric.factory.AbstractBcCbcPaddedCipherFactory;
import org.xwiki.crypto.params.cipher.symmetric.KeyParameter;
import org.xwiki.crypto.params.cipher.symmetric.RC5KeyParameters;

@Component
@Singleton
@Named(value="RC5-64/CBC/PKCS7Padding")
public class BcRc5b128CbcPaddedCipherFactory
extends AbstractBcCbcPaddedCipherFactory {
    private static final int[] KEY_SIZES = BcRc5b128CbcPaddedCipherFactory.newKeySizeArray(0, 256, 8);

    @Override
    protected CipherParameters getBcKeyParameter(KeyParameter parameter) {
        if (parameter instanceof RC5KeyParameters) {
            return new RC5Parameters(parameter.getKey(), ((RC5KeyParameters)parameter).getRounds());
        }
        return new org.bouncycastle.crypto.params.KeyParameter(parameter.getKey());
    }

    @Override
    protected BlockCipher getEngineInstance() {
        return new RC564Engine();
    }

    @Override
    public int[] getSupportedKeySizes() {
        return KEY_SIZES;
    }
}

