/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.digest.factory;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.crypto.Digest;
import org.xwiki.crypto.DigestFactory;
import org.xwiki.crypto.internal.digest.factory.AbstractBcDigestFactory;

@Component
@Singleton
public class DefaultDigestFactory
extends AbstractBcDigestFactory {
    private static final RuntimeException UNSUPPORTED = new UnsupportedOperationException("Unexpected internal function call.");
    @Inject
    private ComponentManager manager;

    @Override
    public org.bouncycastle.crypto.Digest getDigestInstance() {
        throw UNSUPPORTED;
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        throw UNSUPPORTED;
    }

    @Override
    public Digest getInstance() {
        throw new UnsupportedOperationException("Sorry, cannot get an instance without a determined algorithm.");
    }

    @Override
    public Digest getInstance(byte[] encoded) {
        AlgorithmIdentifier algId = AlgorithmIdentifier.getInstance((Object)encoded);
        return this.getFactory(algId.getAlgorithm()).getInstance();
    }

    private DigestFactory getFactory(ASN1ObjectIdentifier algId) {
        try {
            return (DigestFactory)this.manager.getInstance(DigestFactory.class, algId.getId());
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedOperationException("Digest algorithm not found.", e);
        }
    }
}

