/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.asymmetric.generator;

import java.security.SecureRandom;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.bouncycastle.crypto.generators.DSAParametersGenerator;
import org.bouncycastle.crypto.params.DSAParameterGenerationParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAValidationParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.crypto.DigestFactory;
import org.xwiki.crypto.KeyParametersGenerator;
import org.xwiki.crypto.internal.digest.factory.AbstractBcDigestFactory;
import org.xwiki.crypto.params.generator.KeyGenerationParameters;
import org.xwiki.crypto.params.generator.KeyParametersGenerationParameters;
import org.xwiki.crypto.params.generator.asymmetric.DSAKeyGenerationParameters;
import org.xwiki.crypto.params.generator.asymmetric.DSAKeyParametersGenerationParameters;
import org.xwiki.crypto.params.generator.asymmetric.DSAKeyValidationParameters;

@Component
@Singleton
@Named(value="DSA")
public class BcDSAKeyParameterGenerator
implements KeyParametersGenerator {
    @Inject
    private Provider<SecureRandom> random;
    @Inject
    private ComponentManager manager;

    @Override
    public KeyGenerationParameters generate() {
        return this.generate(new DSAKeyParametersGenerationParameters());
    }

    @Override
    public KeyGenerationParameters generate(KeyParametersGenerationParameters parameters) {
        if (!(parameters instanceof DSAKeyParametersGenerationParameters)) {
            throw new IllegalArgumentException("Invalid parameters for DSA key parameters generator: " + parameters.getClass().getName());
        }
        DSAParameters dsaParams = this.getDsaParameters((SecureRandom)this.random.get(), (DSAKeyParametersGenerationParameters)parameters);
        DSAValidationParameters dsaValidParams = dsaParams.getValidationParameters();
        return new DSAKeyGenerationParameters(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG(), new DSAKeyValidationParameters(dsaValidParams.getSeed(), dsaValidParams.getCounter(), BcDSAKeyParameterGenerator.getUsage(dsaValidParams.getUsageIndex())));
    }

    DSAParameters getDsaParameters(SecureRandom random, DSAKeyParametersGenerationParameters params) {
        DSAParametersGenerator paramGen = this.getGenerator(params.getHashHint());
        if (params.use186r3()) {
            DSAParameterGenerationParameters p = new DSAParameterGenerationParameters(params.getPrimePsize() * 8, params.getPrimeQsize() * 8, params.getCertainty(), random, BcDSAKeyParameterGenerator.getUsageIndex(params.getUsage()));
            paramGen.init(p);
        } else {
            paramGen.init(params.getStrength() * 8, params.getCertainty(), random);
        }
        return paramGen.generateParameters();
    }

    private DSAParametersGenerator getGenerator(String hint) {
        DigestFactory factory;
        if (hint == null || hint.equals("SHA-1")) {
            return new DSAParametersGenerator();
        }
        try {
            factory = (DigestFactory)this.manager.getInstance(DigestFactory.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedOperationException("Cryptographic hash (digest) algorithm not found.", e);
        }
        if (!(factory instanceof AbstractBcDigestFactory)) {
            throw new IllegalArgumentException("Requested cryptographic hash algorithm is not implemented by a factory compatible with this factory. Factory found: " + factory.getClass().getName());
        }
        return new DSAParametersGenerator(((AbstractBcDigestFactory)factory).getDigestInstance());
    }

    static int getUsageIndex(DSAKeyValidationParameters.Usage usage) {
        if (usage == DSAKeyValidationParameters.Usage.DIGITAL_SIGNATURE) {
            return 1;
        }
        if (usage == DSAKeyValidationParameters.Usage.KEY_ESTABLISHMENT) {
            return 2;
        }
        return -1;
    }

    private static DSAKeyValidationParameters.Usage getUsage(int usage) {
        if (usage == 1) {
            return DSAKeyValidationParameters.Usage.DIGITAL_SIGNATURE;
        }
        if (usage == 2) {
            return DSAKeyValidationParameters.Usage.KEY_ESTABLISHMENT;
        }
        return DSAKeyValidationParameters.Usage.ANY;
    }
}

