/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.digest;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.io.DigestInputStream;
import org.bouncycastle.crypto.io.DigestOutputStream;
import org.xwiki.crypto.Digest;
import org.xwiki.crypto.params.DigestParameters;

public class BouncyCastleDigest
implements Digest {
    private final org.bouncycastle.crypto.Digest digest;
    private AlgorithmIdentifier algId;
    private DigestParameters parameters;

    public BouncyCastleDigest(org.bouncycastle.crypto.Digest digest, AlgorithmIdentifier algId, DigestParameters parameters) {
        this.digest = digest;
        this.algId = algId;
        this.parameters = parameters;
    }

    @Override
    public String getAlgorithmName() {
        return this.digest.getAlgorithmName();
    }

    @Override
    public int getDigestSize() {
        return this.digest.getDigestSize();
    }

    @Override
    public DigestParameters getParameters() {
        return this.parameters;
    }

    @Override
    public FilterInputStream getInputStream(InputStream is) {
        this.digest.reset();
        return new DigestInputStream(is, this.digest);
    }

    @Override
    public OutputStream getOutputStream() {
        this.digest.reset();
        return new DigestOutputStream(this.digest);
    }

    @Override
    public void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    @Override
    public void update(byte[] input, int inputOffset, int inputLen) {
        this.digest.update(input, inputOffset, inputLen);
    }

    @Override
    public byte[] digest() {
        byte[] dig = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(dig, 0);
        return dig;
    }

    @Override
    public byte[] digest(byte[] input) {
        this.update(input);
        return this.digest();
    }

    @Override
    public byte[] digest(byte[] input, int inputOffset, int inputLen) {
        this.update(input, inputOffset, inputLen);
        return this.digest();
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algId;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.getAlgorithmIdentifier().getEncoded();
    }
}

