/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.asymmetric.generator;

import java.security.SecureRandom;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.bouncycastle.crypto.generators.DHParametersGenerator;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHValidationParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.KeyParametersGenerator;
import org.xwiki.crypto.params.generator.KeyGenerationParameters;
import org.xwiki.crypto.params.generator.KeyParametersGenerationParameters;
import org.xwiki.crypto.params.generator.asymmetric.DHKeyGenerationParameters;
import org.xwiki.crypto.params.generator.asymmetric.DHKeyParametersGenerationParameters;
import org.xwiki.crypto.params.generator.asymmetric.DHKeyValidationParameters;

@Component
@Singleton
@Named(value="DH")
public class BcDHKeyParameterGenerator
implements KeyParametersGenerator {
    @Inject
    private Provider<SecureRandom> random;

    @Override
    public KeyGenerationParameters generate() {
        return this.generate(new DHKeyParametersGenerationParameters());
    }

    @Override
    public KeyGenerationParameters generate(KeyParametersGenerationParameters parameters) {
        if (!(parameters instanceof DHKeyParametersGenerationParameters)) {
            throw new IllegalArgumentException("Invalid parameters for DH key parameters generator: " + parameters.getClass().getName());
        }
        DHParameters dhParams = BcDHKeyParameterGenerator.getDhParameters((SecureRandom)this.random.get(), (DHKeyParametersGenerationParameters)parameters);
        DHValidationParameters dhValidParams = dhParams.getValidationParameters();
        return new DHKeyGenerationParameters(dhParams.getP(), dhParams.getG(), dhParams.getQ(), dhParams.getM() / 8, dhParams.getL() / 8, dhParams.getJ(), dhValidParams != null ? new DHKeyValidationParameters(dhValidParams.getSeed(), dhValidParams.getCounter()) : null);
    }

    static DHParameters getDhParameters(SecureRandom random, DHKeyParametersGenerationParameters params) {
        DHParametersGenerator paramGen = new DHParametersGenerator();
        paramGen.init(params.getStrength() * 8, params.getCertainty(), random);
        return paramGen.generateParameters();
    }
}

