/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.asymmetric.keyfactory;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import org.xwiki.crypto.AsymmetricKeyFactory;
import org.xwiki.crypto.internal.asymmetric.BcAsymmetricKeyParameters;
import org.xwiki.crypto.internal.asymmetric.BcPrivateKeyParameters;
import org.xwiki.crypto.internal.asymmetric.BcPublicKeyParameters;
import org.xwiki.crypto.params.cipher.asymmetric.PrivateKeyParameters;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;

public abstract class AbstractBcKeyFactory
implements AsymmetricKeyFactory,
AsymmetricKeyInfoConverter {
    private static final String PRIVATE = "private";
    private static final String PUBLIC = "public";
    private static final String CLASS_ERROR = "Expected a %s %s key, but key class is %s.";
    private static final String ALGORITHM_ERROR = "Expected a %s %s key, but key algorithm is %s.";

    protected abstract AsymmetricKeyInfoConverter getKeyInfoConverter();

    protected abstract String checkKeyType(BcAsymmetricKeyParameters var1);

    @Override
    public PublicKeyParameters fromX509(byte[] encoded) throws IOException {
        BcPublicKeyParameters key = new BcPublicKeyParameters(PublicKeyFactory.createKey((byte[])encoded));
        String keyType = this.checkKeyType(key);
        if (keyType != null) {
            throw new IllegalArgumentException(String.format(CLASS_ERROR, keyType, PUBLIC, key.getParameters().getClass().getName()));
        }
        return key;
    }

    @Override
    public PrivateKeyParameters fromPKCS8(byte[] encoded) throws IOException {
        BcPrivateKeyParameters key = new BcPrivateKeyParameters(PrivateKeyFactory.createKey((byte[])encoded));
        String keyType = this.checkKeyType(key);
        if (keyType != null) {
            throw new IllegalArgumentException(String.format(CLASS_ERROR, keyType, PRIVATE, key.getParameters().getClass().getName()));
        }
        return key;
    }

    @Override
    public PublicKeyParameters fromKey(PublicKey publicKey) {
        try {
            BcPublicKeyParameters key = new BcPublicKeyParameters(PublicKeyFactory.createKey((byte[])publicKey.getEncoded()));
            String keyType = this.checkKeyType(key);
            if (keyType != null) {
                throw new IllegalArgumentException(String.format(ALGORITHM_ERROR, keyType, PUBLIC, publicKey.getAlgorithm()));
            }
            return key;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid public key: " + publicKey.getClass().getName());
        }
    }

    @Override
    public PrivateKeyParameters fromKey(PrivateKey privateKey) {
        try {
            BcPrivateKeyParameters key = new BcPrivateKeyParameters(PrivateKeyFactory.createKey((byte[])privateKey.getEncoded()));
            String keyType = this.checkKeyType(key);
            if (keyType != null) {
                throw new IllegalArgumentException(String.format(ALGORITHM_ERROR, keyType, PRIVATE, privateKey.getAlgorithm()));
            }
            return key;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid private key: " + privateKey.getClass().getName());
        }
    }

    @Override
    public PublicKey toKey(PublicKeyParameters key) {
        try {
            if (key instanceof BcAsymmetricKeyParameters) {
                String keyType = this.checkKeyType((BcAsymmetricKeyParameters)((Object)key));
                if (keyType != null) {
                    throw new IllegalArgumentException(String.format(CLASS_ERROR, keyType, PUBLIC, key.getClass().getName()));
                }
                return this.generatePublic(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)((BcAsymmetricKeyParameters)((Object)key)).getParameters()));
            }
            return this.generatePublic(SubjectPublicKeyInfo.getInstance((Object)key.getEncoded()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid public key parameters: " + key.getClass().getName());
        }
    }

    @Override
    public PrivateKey toKey(PrivateKeyParameters key) {
        try {
            if (key instanceof BcAsymmetricKeyParameters) {
                String keyType = this.checkKeyType((BcAsymmetricKeyParameters)((Object)key));
                if (keyType != null) {
                    throw new IllegalArgumentException(String.format(CLASS_ERROR, keyType, PRIVATE, key.getClass().getName()));
                }
                return this.generatePrivate(PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)((BcAsymmetricKeyParameters)((Object)key)).getParameters()));
            }
            return this.generatePrivate(PrivateKeyInfo.getInstance((Object)key.getEncoded()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid private key parameters: " + key.getClass().getName());
        }
    }

    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
        return this.getKeyInfoConverter().generatePrivate(privateKeyInfo);
    }

    public PublicKey generatePublic(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return this.getKeyInfoConverter().generatePublic(publicKeyInfo);
    }
}

