/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.xwiki.crypto.internal.asymmetric.BcPublicKeyParameters;
import org.xwiki.crypto.params.cipher.CipherParameters;
import org.xwiki.crypto.params.cipher.asymmetric.PublicKeyParameters;
import org.xwiki.crypto.pkix.internal.BcUtils;
import org.xwiki.crypto.pkix.internal.extension.BcX509Extensions;
import org.xwiki.crypto.pkix.params.x509certificate.DistinguishedName;
import org.xwiki.crypto.pkix.params.x509certificate.X509CertifiedPublicKey;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509Extensions;
import org.xwiki.crypto.signer.Signer;
import org.xwiki.crypto.signer.SignerFactory;
import org.xwiki.crypto.signer.internal.factory.BcSignerFactory;

public class BcX509CertifiedPublicKey
implements X509CertifiedPublicKey {
    private final X509CertificateHolder holder;
    private final SignerFactory signerFactory;

    BcX509CertifiedPublicKey(X509CertificateHolder holder, SignerFactory signerFactory) {
        this.holder = holder;
        this.signerFactory = signerFactory;
    }

    public X509CertificateHolder getX509CertificateHolder() {
        return this.holder;
    }

    @Override
    public DistinguishedName getIssuer() {
        return new DistinguishedName(this.holder.getIssuer());
    }

    @Override
    public DistinguishedName getSubject() {
        return new DistinguishedName(this.holder.getSubject());
    }

    @Override
    public Date getNotAfter() {
        return this.holder.getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return this.holder.getNotBefore();
    }

    @Override
    public int getVersionNumber() {
        return this.holder.getVersionNumber();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.holder.getSerialNumber();
    }

    @Override
    public boolean isValidOn(Date date) {
        return this.holder.isValidOn(date);
    }

    @Override
    public X509Extensions getExtensions() {
        return new BcX509Extensions(this.holder.getExtensions());
    }

    @Override
    public PublicKeyParameters getPublicKeyParameters() {
        try {
            return new BcPublicKeyParameters(PublicKeyFactory.createKey((SubjectPublicKeyInfo)this.holder.getSubjectPublicKeyInfo()));
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Unsupported public key encoding.", e);
        }
    }

    @Override
    public boolean isSignedBy(PublicKeyParameters publicKey) throws GeneralSecurityException {
        TBSCertificate tbsCert = this.holder.toASN1Structure().getTBSCertificate();
        if (!BcUtils.isAlgorithlIdentifierEqual(tbsCert.getSignature(), this.holder.getSignatureAlgorithm())) {
            return false;
        }
        Signer signer = null;
        if (this.signerFactory instanceof BcSignerFactory) {
            signer = ((BcSignerFactory)this.signerFactory).getInstance(false, (CipherParameters)publicKey, tbsCert.getSignature());
        } else {
            try {
                signer = this.signerFactory.getInstance(false, (CipherParameters)publicKey, this.holder.getSignatureAlgorithm().getEncoded());
            }
            catch (IOException e) {
                return false;
            }
        }
        try {
            return BcUtils.updateDEREncodedObject(signer, (ASN1Encodable)tbsCert).verify(this.holder.getSignature());
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.holder.getEncoded();
    }
}

