/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.pkix.params.x509certificate;

import org.xwiki.crypto.pkix.params.CertificateGenerationParameters;
import org.xwiki.crypto.pkix.params.x509certificate.extension.X509Extensions;
import org.xwiki.stability.Unstable;

@Unstable
public class X509CertificateGenerationParameters
implements CertificateGenerationParameters {
    private static final int DEFAULT_VALIDITY = 500;
    private final Version version;
    private final int validity;
    private final X509Extensions extensions;

    public X509CertificateGenerationParameters() {
        this(500);
    }

    public X509CertificateGenerationParameters(X509Extensions extensions) {
        this(500, extensions);
    }

    public X509CertificateGenerationParameters(int validity) {
        this(Version.V1, validity, null);
    }

    public X509CertificateGenerationParameters(int validity, X509Extensions extensions) {
        this(Version.V3, validity, extensions);
    }

    public X509CertificateGenerationParameters(Version version, int validity, X509Extensions extensions) {
        this.version = version;
        this.validity = validity;
        this.extensions = extensions;
    }

    public Version getX509Version() {
        return this.version;
    }

    public int getValidity() {
        return this.validity;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    public static enum Version {
        V1,
        V2,
        V3;

    }
}

